<?php

namespace ViartasShop\Account\Forms;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use ViartasModules\Pages\Models\Accounting\Page;
use ViartasShop\Cart\Models\Accounting\Country;

class CustomerForm extends Form
{
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'customers-form',
            'class' => 'backend-form-validator',
            'action' => 'create',
            'routes' => [
                'create' => [
                    'route' => 'web.account.customers.create',
                    'routeAttributes' => [],
                ],
                'update' => [
                    '_method' => 'POST',
                    'route' => 'web.account.customers.edit',
                    'routeAttributes' => [
                        'id' => 'id',
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        return [
            'group1' => [
                'title' => [
                    'title' => __('globals.title'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'required' => true,
                    //'placeholder' => true,
                    'label_position' => 'bottom',
                    'parent_class' => 'form-floating mb-4 theme-form-floating',
                ],
                'first_name' => [
                    'title' => __('globals.first_name'),
                    'type' => Field::TEXT,
                    'size' => 4,
                    'required' => true,
                    //'placeholder' => true,
                    'label_position' => 'bottom',
                    'parent_class' => 'form-floating mb-4 theme-form-floating',
                ],
                'last_name' => [
                    'title' => __('globals.last_name'),
                    'type' => Field::TEXT,
                    'size' => 4,
                    'required' => true,
                    //'placeholder' => true,
                    'label_position' => 'bottom',
                    'parent_class' => 'form-floating mb-4 theme-form-floating',
                ],
                'phone' => [
                    'title' => __('globals.phone'),
                    'type' => Field::TEXT,
                    'size' => 4,
                    'required' => true,
                    //'placeholder' => true,
                    'label_position' => 'bottom',
                    'parent_class' => 'form-floating mb-4 theme-form-floating',
                ],
                'country_id' => [
                    'title' => __('globals.country'),
                    'type' => Field::SELECT,
                    'size' => 6,
                    'required' => true,
                    'options' => Country::all()->pluck('title', 'id')->toArray(),
                    //'placeholder' => true,
                    'label_position' => 'bottom',
                    'parent_class' => 'form-floating mb-4 theme-form-floating',
                ],
                'city' => [
                    'title' => __('globals.city'),
                    'type' => Field::TEXT,
                    'size' => 6,
                    'required' => true,
                    //'placeholder' => true,
                    'label_position' => 'bottom',
                    'parent_class' => 'form-floating mb-4 theme-form-floating',
                ],
                'address' => [
                    'title' => __('globals.address'),
                    'type' => Field::TEXT,
                    'size' => 8,
                    'required' => true,
                    //'placeholder' => true,
                    'label_position' => 'bottom',
                    'parent_class' => 'form-floating mb-4 theme-form-floating',
                ],
                'zip' => [
                    'title' => __('globals.zip'),
                    'type' => Field::TEXT,
                    'size' => 4,
                    'required' => true,
                    //'placeholder' => true,
                    'label_position' => 'bottom',
                    'parent_class' => 'form-floating mb-4 theme-form-floating',
                ],
                'is_company' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'required' => false,
                    'rules' => ['bool'],
                    'parent_class' => 'form-group fv-row mb-2 mt-2',
                    'options' => [
                        '1' => __('globals.is-company'),
                    ],
                ],
                'company_name' => [
                    'title' => __('globals.company-name'),
                    'type' => Field::TEXT,
                    'size' => 4,
                    'rules' => ['required_if:is_company,1'],
                    //'placeholder' => true,
                    'label_position' => 'bottom',
                    'parent_class' => 'form-floating mb-4 theme-form-floating',
                ],
                'code' => [
                    'title' => __('globals.company-code'),
                    'type' => Field::TEXT,
                    'size' => 4,
                    'rules' => ['required_if:is_company,1'],
                    'placeholder' => false,
                    'label_position' => 'bottom',
                    'parent_class' => 'form-floating mb-4 theme-form-floating',
                ],
                'vat' => [
                    'title' => __('globals.company-vat-code'),
                    'type' => Field::TEXT,
                    'size' => 4,
                    'rules' => ['required_if:is_company,1'],
                    //'placeholder' => true,
                    'label_position' => 'bottom',
                    'parent_class' => 'form-floating mb-4 theme-form-floating',
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        return [
            'group1' => [
                'title' => __('customers.create'),
                'layout' => Group::MODAL,
                'size' => 12,
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
