<?php

namespace ViartasShop\Account\Controllers;

use Illuminate\Support\Facades\Route;
use Illuminate\View\Factory;
use Illuminate\View\View;
use ViartasCore\Core\Controllers\WebController;
use ViartasCore\Core\Facades\Viartas;

class ProfileController extends WebController
{
    /**
     * AccountController constructor.
     */
    public function __construct()
    {
        $route = Route::currentRouteName();
        $route = str_replace('.'.Viartas::driver()->locale()->path(), '', $route);

        view()->share('route', $route);

        parent::__construct();
    }

    /**
     * @return Factory|View
     */
    public function index(): Factory|View
    {
        $user = auth()->user();
        view()->share('user', $user);

        return theme_view('web.account.profile');
    }
}
