<?php

namespace ViartasShop\Account\Controllers;

use Illuminate\Support\Facades\Route;
use Illuminate\View\Factory;
use Illuminate\View\View;
use ViartasCore\Core\Controllers\WebController;
use ViartasCore\Core\Facades\Viartas;

class AccountController extends WebController
{
    /**
     * AccountController constructor.
     */
    public function __construct()
    {
        $route = Route::currentRouteName();
        $route = str_replace('.'.Viartas::driver()->locale()->path(), '', $route);

        view()->share('route', $route);

        parent::__construct();
    }

    /**
     * @return Factory|View
     */
    public function index(): Factory|View
    {
        $user = auth()->user();
        view()->share('user', $user);

        return theme_view('web.account.index');
    }

    /**
     * @return Factory|View
     */
    public function addresses(): Factory|View
    {
        return theme_view('web.account.addresses');
    }

    /**
     * @return Factory|View
     */
    public function cards(): Factory|View
    {
        return theme_view('web.account.cards');
    }

    /**
     * @return Factory|View
     */
    public function customers(): Factory|View
    {
        return theme_view('web.account.customers');
    }

    /**
     * @return Factory|View
     */
    public function orders(): Factory|View
    {
        return theme_view('web.account.orders');
    }

    /**
     * @return Factory|View
     */
    public function privacy(): Factory|View
    {
        return theme_view('web.account.privacy');
    }

    /**
     * @return Factory|View
     */
    public function profile(): Factory|View
    {
        return theme_view('web.account.profile');
    }

    /**
     * @return Factory|View
     */
    public function terminals(): Factory|View
    {
        return theme_view('web.account.terminals');
    }

    /**
     * @return Factory|View
     */
    public function wishlist(): Factory|View
    {
        return theme_view('web.account.wishlist');
    }
}
