<?php

use ViartasShop\Account\Controllers\AccountController;
use ViartasShop\Account\Controllers\CustomersController;
use ViartasShop\Account\Controllers\ProfileController;

Route::prefix('account')->group(function () {
    Route::get('/', [AccountController::class, 'index'])->name('account.index');

    Route::prefix('profile')->group(function () {
        Route::get('/', [ProfileController::class, 'index'])->name('account.profile');
        Route::post('/', [ProfileController::class, 'update']);
    });

    Route::prefix('customers')->group(function () {
        Route::get('/', [CustomersController::class, 'index'])->name('account.customers');
        Route::get('/create', [CustomersController::class, 'create'])->name('account.customers.create');
        Route::post('/create', [CustomersController::class, 'store']);
        Route::get('/{id}', [CustomersController::class, 'edit'])->name('account.customers.edit');
        Route::post('/{id}', [CustomersController::class, 'update']);
        Route::post('/delete/{id}', [CustomersController::class, 'delete'])->name('account.customers.delete');
    });

    Route::get('/addresses', [AccountController::class, 'addresses'])->name('account.addresses');
    Route::get('/cards', [AccountController::class, 'cards'])->name('account.cards');
    Route::get('/orders', [AccountController::class, 'orders'])->name('account.orders');
    Route::get('/privacy', [AccountController::class, 'privacy'])->name('account.privacy');
    Route::get('/terminals', [AccountController::class, 'terminals'])->name('account.terminals');
    Route::get('/wishlist', [AccountController::class, 'wishlist'])->name('account.wishlist');
});

Route::prefix('account')->group(function () {

});
