@extends('web.account.theme')
@section('part')
    <div class="dashboard-home">
        <div class="title">
            <h2>{{ $module->meta->title ?? $module->title }}</h2>
            <span class="title-leaf">
                <svg class="icon-width bg-gray">
                    <use xlink:href="../assets/svg/leaf.svg#leaf"></use>
                </svg>
            </span>
        </div>
    <div class="dashboard-user-name">
        <h6 class="text-content">Hello, <b class="text-title">{{ Auth::user()->name }}</b></h6>
        <p class="text-content">From your My Account Dashboard you have the ability to
            view a snapshot of your recent account activity and update your account
            information. Select a link below to view or edit information.</p>
    </div>

    <div class="total-box">
        <div class="row g-sm-4 g-3">
            <div class="col-xxl-4 col-lg-6 col-md-4 col-sm-6">
                <div class="total-contain">
                    <img src="{{ theme()->publicPath('images/svg/order.svg') }}"
                         class="img-1 blur-up lazyload" alt="">
                    <img src="{{ theme()->publicPath('images/svg/order.svg') }}" class="blur-up lazyload"
                         alt="">
                    <div class="total-detail">
                        <h5>Total Order</h5>
                        <h3>3658</h3>
                    </div>
                </div>
            </div>

            <div class="col-xxl-4 col-lg-6 col-md-4 col-sm-6">
                <div class="total-contain">
                    <img src="{{ theme()->publicPath('images/svg/pending.svg') }}"
                         class="img-1 blur-up lazyload" alt="">
                    <img src="{{ theme()->publicPath('images/svg/pending.svg') }}" class="blur-up lazyload"
                         alt="">
                    <div class="total-detail">
                        <h5>Total Pending Order</h5>
                        <h3>254</h3>
                    </div>
                </div>
            </div>

            <div class="col-xxl-4 col-lg-6 col-md-4 col-sm-6">
                <div class="total-contain">
                    <img src="{{ theme()->publicPath('images/svg/wishlist.svg') }}"
                         class="img-1 blur-up lazyload" alt="">
                    <img src="{{ theme()->publicPath('images/svg/wishlist.svg') }}"
                         class="blur-up lazyload" alt="">
                    <div class="total-detail">
                        <h5>Total Wishlist</h5>
                        <h3>32158</h3>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="dashboard-title">
        <h3>Account Information</h3>
    </div>

    <div class="row g-4">
        <div class="col-xxl-6">
            <div class="dashboard-content-title">
                <h4>Contact Information <a href="javascript:void(0)"
                                           data-bs-toggle="modal" data-bs-target="#editProfile">Edit</a>
                </h4>
            </div>
            <div class="dashboard-detail">
                <h6 class="text-content">MARK JECNO</h6>
                <h6 class="text-content">vicki.pope@gmail.com</h6>
                <a href="javascript:void(0)">Change Password</a>
            </div>
        </div>

        <div class="col-xxl-6">
            <div class="dashboard-content-title">
                <h4>Newsletters <a href="javascript:void(0)" data-bs-toggle="modal"
                                   data-bs-target="#editProfile">Edit</a></h4>
            </div>
            <div class="dashboard-detail">
                <h6 class="text-content">You are currently not subscribed to any
                    newsletter</h6>
            </div>
        </div>

        <div class="col-12">
            <div class="dashboard-content-title">
                <h4>Address Book <a href="javascript:void(0)" data-bs-toggle="modal"
                                    data-bs-target="#editProfile">Edit</a></h4>
            </div>

            <div class="row g-4">
                <div class="col-xxl-6">
                    <div class="dashboard-detail">
                        <h6 class="text-content">Default Billing Address</h6>
                        <h6 class="text-content">You have not set a default billing
                            address.</h6>
                        <a href="javascript:void(0)" data-bs-toggle="modal"
                           data-bs-target="#editProfile">Edit Address</a>
                    </div>
                </div>

                <div class="col-xxl-6">
                    <div class="dashboard-detail">
                        <h6 class="text-content">Default Shipping Address</h6>
                        <h6 class="text-content">You have not set a default shipping
                            address.</h6>
                        <a href="javascript:void(0)" data-bs-toggle="modal"
                           data-bs-target="#editProfile">Edit Address</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection
