@extends('web.account.theme')
@section('part')
    <div class="dashboard-address">
        <div class="title title-flex">
            <div>
                <h2>{{ $module->meta->title ?? $module->title }}</h2>
                <span class="title-leaf">
                    <svg class="icon-width bg-gray">
                        <use xlink:href="../assets/svg/leaf.svg#leaf"></use>
                    </svg>
                </span>
            </div>

            <button class="btn theme-bg-color text-white btn-sm fw-bold mt-lg-0 mt-3" data-bs-toggle="modal" data-bs-target="#add-address">
                <i data-feather="plus" class="me-2"></i>
                {{ __('globals.address_add_new') }}
            </button>
        </div>

        <div class="row g-sm-4 g-3">
            @foreach($customers as $customer)
            <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <div class="address-box">
                    <div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="jack" id="flexRadioDefault2" checked>
                        </div>

                        <div class="label">
                            <label>{{ $customer->title }}</label>
                        </div>

                        <div class="table-responsive address-table">
                            <table class="table">
                                <tbody>
                                @if($customer->is_company)
                                    <tr>
                                        <td colspan="2">{{ ($customer->company_name) }}</td>
                                    </tr>
                                    <tr>
                                        <td>{{ __('globals.company_code') }}: </td>
                                        <td>
                                            <p>{{ $customer->vat }}</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>{{ __('globals.vat_code') }}: </td>
                                        <td>
                                            <p>{{ $customer->vat }}</p>
                                        </td>
                                    </tr>
                                @else
                                    <tr>
                                        <td colspan="2">{{ ($customer->first_name) }} {{ ($customer->last_name) }}</td>
                                    </tr>
                                @endif

                                <tr>
                                    <td>{{ __('globals.address') }}: </td>
                                    <td>
                                        <p>{{ $customer->address }}, {{ $customer->zip }}, {{ $customer->city }}, {{ $customer->country->iso2 }}</p>
                                    </td>
                                </tr>

                                <tr>
                                    <td>{{ __('globals.phone') }}: </td>
                                    <td>{{ $customer->phone }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="button-group">
                        <button class="btn btn-sm add-button w-100 load-data-for-edit" data-url="{{ route('web.account.customers.edit', ['id' => $customer->id]) }}" data-bs-toggle="modal" data-bs-target="#edit-address">
                            <i data-feather="edit"></i>
                            {{ __('globals.edit') }}
                        </button>

                        <button href="{{ route('web.account.customers.delete', ['id' => $customer->id]) }}" data-title="{{ __('globals.remove_customer_confirmation_text') }}" class="btn btn-sm add-button w-100 confirm-delete-element" data-bs-toggle="modal" data-bs-target="#removeElement">
                            <i data-feather="trash-2"></i>
                            {{ __('globals.remove') }}
                        </button>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>

    <!-- Add address modal box start -->
    <div class="modal fade theme-modal" id="add-address" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-fullscreen-sm-down">
            <div class="modal-content" style="padding: 20px;">
                {!! $form->renderForm() !!}
            </div>
        </div>
    </div>
    <!-- Add address modal box end -->

    <!-- Add address modal box start -->
    <div class="modal fade theme-modal" id="edit-address" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-fullscreen-sm-down">
            <div class="modal-content" style="padding: 20px;">
                <div class="loaded-data"></div>
            </div>
        </div>
    </div>
    <!-- Add address modal box end -->

    <!-- Remove Profile Modal Start -->
    <div class="modal fade theme-modal remove-profile" id="removeElement" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-fullscreen-sm-down">
            <div class="modal-content">
                <form action="" method="post" class="remove-form">
                    @csrf
                    @method('POST')
                    <div class="modal-header d-block text-center">
                        <h5 class="modal-title w-100" id="exampleModalLabel22">{{ __('globals.are_you_sure?') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal">
                            <i class="fa-solid fa-xmark"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="remove-box">
                            <p class="remove-box-text"></p>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-animation btn-md fw-bold" data-bs-dismiss="modal">{{ __('globals.no') }}</button>
                        <button type="submit" class="btn theme-bg-color btn-md fw-bold text-light">{{ __('globals.yes') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts-js')
    <script>
        $(document).ready(function () {
            $('.confirm-delete-element').on('click', function () {
                $('.remove-box-text').html($(this).attr('data-title'));
                $('.remove-form').attr('action', $(this).attr('href'));
            });
        });
    </script>
@endsection
