<?php

namespace ViartasModules\Posts\Models\Accounting;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use ViartasCore\Core\Models\BaseModel;
use ViartasCore\Core\Traits\DefinesAsCacheItem;
use ViartasModules\PostCategories\Models\Accounting\PostCategory;

class Post extends BaseModel
{
    use DefinesAsCacheItem;

    /**
     * @var string[]
     */
    protected $fillable = [
        'title', 'content', 'slug',
        'user_id', 'post_category_id',
        'is_visible',
    ];

    /**
     * @var string
     */
    protected string $module = 'posts';

    /**
     * @var bool
     */
    protected bool $usesRecursiveRelations = false;

    /**
     * @var string
     */
    protected string $element_title = 'Post';

    /**
     * @return string
     */
    public function getParentKeyName(): string
    {
        return 'title'; //workaround
    }

    /**
     * @return BelongsTo
     */
    public function category(): BelongsTo
    {
        return $this->belongsTo(PostCategory::class, 'post_category_id', 'id');
    }
}
