<?php

use ViartasModules\Posts\Controllers\Accounting\PostsController;

Route::prefix('posts')->group(function () {
    Route::get('/', [PostsController::class, 'index'])->name('posts.index');
    Route::get('/create', [PostsController::class, 'create'])->name('posts.create');
    Route::post('/create', [PostsController::class, 'store'])->name('posts.create');
    Route::get('/{id}/edit', [PostsController::class, 'edit'])->name('posts.edit');
    Route::post('/{id}/edit', [PostsController::class, 'update'])->name('posts.edit');
    Route::patch('/{id}/edit', [PostsController::class, 'updateOneField'])->name('posts.edit');
    Route::post('/{id}/destroy', [PostsController::class, 'destroy'])->name('posts.destroy');
    Route::get('/{id}/upload/images', [PostsController::class, 'uploadImages'])->name('posts.upload.images');
});
