<?php

namespace ViartasModules\PostCategories\Models\Accounting;

use ViartasCore\Core\Models\BaseModel;
use ViartasCore\Core\Traits\DefinesAsCacheItem;

class PostCategory extends BaseModel
{
    use DefinesAsCacheItem;

    /**
     * @var string[]
     */
    protected $fillable = [
        'title', 'content', 'slug',
        'user_id', 'post_category_id',
        'is_visible',
    ];

    /**
     * @var string
     */
    protected string $module = 'post-categories';

    /**
     * @var string
     */
    protected string $element_title = 'Post category';

    /**
     * @return string
     */
    public function getParentKeyName(): string
    {
        return 'post_category_id';
    }

    /**
     * @return string
     */
    public function generateRoute(): string
    {
        $segments = [];

        $child = $this->ancestorsAndSelf()->get()->toTree()->first();

        while ($child !== false) {
            $element = $child;

            $segments[] = $element->slug;

            if ($element->children->count()) {
                $child = $element->children->first();
            } else {
                $child = false;
            }
        }

        return implode('/', $segments);
    }
}
