<?php

namespace ViartasModules\PostCategories\Forms\Accounting;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use ViartasModules\PostCategories\Models\Accounting\PostCategory;

class PostCategoriesEditForm extends Form
{
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form1',
            'class' => 'form',
            'action' => 'create',
            'routes' => [
                'create' => [
                    'route' => 'accounting.post-categories.create',
                    'routeAttributes' => [],
                ],
                'update' => [
                    '_method' => 'POST',
                    'route' => 'accounting.post-categories.edit',
                    'routeAttributes' => [
                        'id' => 'id',
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        $pages = PostCategory::query()
            ->whereNull('post_category_id')
            ->with('descendants', function ($q) {
                $q->orderBy('title');
            })
            ->orderBy('title')
            ->get();

        return [
            'group1' => [
                'title' => [
                    'title' => __('Title'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'translatable' => true,
                    'required' => true,
                ],
                'content' => [
                    'title' => __('Content'),
                    'type' => Field::TEXTAREA,
                    'size' => 12,
                    'translatable' => true,
                    'required' => true,
                ],
            ],
            'group2' => [
                'post_category_id' => [
                    'title' => __('Parent'),
                    'type' => Field::SELECT,
                    'size' => 12,
                    'options' => $pages,
                    'nested' => true,
                    'nested_fields' => [
                        'children' => 'descendants',
                        'key' => 'id',
                        'value' => 'title',
                    ],
                ],
                'is_visible' => [
                    'title' => __(''),
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'rules' => ['bool'],
                    'options' => [
                        '1' => __('Visible'),
                    ],
                ],
                'save' => [
                    'title' => __('Save'),
                    'size' => '12',
                    'position' => 'text-end',
                    'class' => 'btn btn-success',
                    'type' => Field::BUTTON_SUBMIT,
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        return [
            'group1' => [
                'title' => __('Post category content'),
                'layout' => Group::CARD,
                'size' => 8,
            ],
            'group2' => [
                'title' => __('Post category settings'),
                'layout' => Group::CARD,
                'size' => 4,
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
