<?php

namespace ViartasModules\PostCategories\Controllers\Accounting;

use App\Forms\Common\ImagesUploadForm;
use ViartasModules\PostCategories\Forms\Accounting\PostCategoriesEditForm;
use ViartasModules\PostCategories\Models\Accounting\PostCategory;
use ViartasModules\PostCategories\Tables\Accounting\PostCategoriesTable;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use ViartasCore\Core\Controllers\AccountingController;

class PostCategoriesController extends AccountingController
{
    /**
     * @param PostCategoriesTable $table
     * @param Request $request
     * @return string|array|View|\Illuminate\Foundation\Application|Factory|Application
     */
    public function index(PostCategoriesTable $table, Request $request): string|array|View|\Illuminate\Foundation\Application|Factory|Application
    {
        return $this->tableBuilder(
            $table, $request, theme_view('accounting.post-categories.index', compact('table'))
        );
    }

    public function create(PostCategoriesEditForm $form)
    {
        return theme_view('accounting.post-categories.edit', [
            'form' => $form->build(),
            'element' => new PostCategory(),
        ]);
    }

    public function store(PostCategoriesEditForm $form)
    {
        $page = PostCategory::create($form->all());

        return theme_redirect()->route('accounting.post-categories.edit', [
            'id' => $page->id,
        ])->with('success', __('post.category.created'));
    }

    public function edit(string $id, PostCategoriesEditForm $form)
    {
        $post_category = PostCategory::findOrFail($id);
        $form = $form->setAction('update')->build($post_category);

        return theme_view('accounting.post-categories.edit', [
            'form' => $form,
            'element' => $post_category,
        ]);
    }

    public function update(string $id, PostCategoriesEditForm $form)
    {
        PostCategory::findOrFail($id)->update($form->all());

        return theme_redirect()->route('accounting.post-categories.edit', [
            'id' => $id,
        ])->with('success', __('post.category.updated'));
    }

    /**
     * @param string $id
     * @param Request $request
     * @return void
     */
    public function updateOneField(string $id, Request $request): void
    {
        PostCategory::findOrFail($id)->update([
            $request->get('field') => $request->get('value')
        ]);
    }

    /**
     * @param string $id
     * @param Request $request
     * @return bool|RedirectResponse
     */
    public function destroy(string $id, Request $request): bool|RedirectResponse
    {
        if ($id !== '0') {
            PostCategory::findOrFail($id)->delete();

            return theme_redirect()->route('accounting.post-categories.index')
                ->with('success', __('post-category.deleted'));
        }

        $this->destroySelected($request);

        return true;
    }

    /**
     * @param Request $request
     * @return void
     */
    public function destroySelected(Request $request): void
    {
        foreach ($request->elements as $element) {
            PostCategory::find($element)->delete();
        }

        Session::flash('success', __('elements.selected.deleted'));
    }

    public function uploadImages($id, ImagesUploadForm $images)
    {
        $page = PostCategory::findOrFail($id);
        $images = $images->build();

        $images->field('images')
            ->setModel(PostCategory::class)
            ->setPrimaryKey('id')
            ->setPrimaryValue($id);

        return theme_view('accounting.post-categories.common', [
            'form' => $images,
            'element' => $page,
        ]);
    }

}
