<?php

use ViartasModules\PostCategories\Controllers\Accounting\PostCategoriesController;

Route::prefix('post-categories')->group(function () {
    Route::get('/', [PostCategoriesController::class, 'index'])->name('post-categories.index');
    Route::get('/create', [PostCategoriesController::class, 'create'])->name('post-categories.create');
    Route::post('/create', [PostCategoriesController::class, 'store'])->name('post-categories.create');
    Route::get('/{id}/edit', [PostCategoriesController::class, 'edit'])->name('post-categories.edit');
    Route::post('/{id}/edit', [PostCategoriesController::class, 'update'])->name('post-categories.edit');
    Route::patch('/{id}/edit', [PostCategoriesController::class, 'updateOneField'])->name('post-categories.edit');
    Route::post('/{id}/destroy', [PostCategoriesController::class, 'destroy'])->name('post-categories.destroy');
    Route::get('/{id}/upload/images', [PostCategoriesController::class, 'uploadImages'])->name('post-categories.upload.images');
});
