<?php

namespace ViartasModules\Pages\Tables\Accounting;

use ViartasBuilders\Tables\DataTables;
use ViartasBuilders\Tables\DataTablesButton;
use ViartasBuilders\Tables\DataTablesRow;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use ViartasModules\Pages\Models\Accounting\Page;

class MenuPagesTable extends DataTables
{
    public function __construct(Request $request)
    {
        parent::__construct(
            new Page(),
            $request
        );

        $this->table();

        $this->addRows([
            $this->fieldId(),
            $this->fieldTitle(),
            $this->fieldParent(),
            $this->fieldSwitch([
                ['label' => __('Visible'), 'value' => "1",],
                ['label' => __('Invisible'), 'value' => "0",]
            ])
                ->field('is_visible')
                ->title(__('Visibility')),
            $this->fieldCheckboxMassActions(),
            $this->button()
                ->add($this->addOneItemButton())
                ->add($this->addManyItemsButton())
                ->add((new DataTablesButton())->editButton()->setColor('warning'))
        ]);
    }

    public function addOneItemButton (): DataTablesButton
    {
        return (new DataTablesButton())
            ->setColor('primary')
            ->setTitle(__('Add one item'))
            ->setIcon('fa-plus-circle')
            ->setClass('add-one-menu-item')

            ->getRoute();
    }

    public function addManyItemsButton (): DataTablesButton
    {
        return (new DataTablesButton())
            ->setColor('primary')
            ->setTitle(__('Add many items button'))
            ->setIcon('fa-layer-group')
            ->setClass('add-one-menu-item-with-children')
            ->getRoute();
    }

    public function table(): self
    {
        $this->setRoute(route('accounting.menus.items.pages'));
        $this->setFilters(route('accounting.menus.items.pages'));
        $this->setId('pages-table');
        $this->setType('simple');
        $this->setClass('pages-table');
        $this->setTitle(__('Pages'));
        $this->setIndexColumn('id');

        return $this;
    }

    public function fieldParent(): DataTablesRow
    {
        return (new DataTablesRow())
            ->field('page_id')
            ->title(__('Parent'))
            ->setSelectable()
            ->render(function (Page $page) {
                if ($page->ancestors->count()) {
                    $parents = '';
                    foreach ($page->ancestors as $ancestor) {
                        $parents .= '<span class="badge badge-primary mx-1">'.$ancestor->title.'</span>';

                        if ($ancestor->ancestors->count()) {
                            $parents .= '<i class="fas fa-arrow-alt-circle-left"></i>';
                        }
                    }

                    return $parents;
                }

                return '<span class="badge badge-secondary mx-1">'.__('Root').'</span>';
            })
            ->order(function (Builder $builder, string $direction) {
                return $builder->withAggregate('parent','title')
                    ->orderBy('parent_title', $direction);
            })
            ->filters(function (Page $page) {
                return array_merge([[
                    'value' => '0',
                    'label' => __('Root'),
                    'values' => [],
                ]], self::treeToFilters(
                    $page::orderBy('page_id')->tree()->get()->toTree(),
                    'id',
                    'title'
                ));
            })
            ->filter(function (Builder $builder, $searches) {
                foreach ($searches as $value => $key) {
                    if ($value == 0) {
                        $builder->whereNull('page_id');
                    } else {
                        $builder->where($key, 'like', '%'.$value.'%');
                    }
                }

                return $builder;
            });
    }
}
