<?php

namespace ViartasModules\Pages\Models\Accounting;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use ViartasCore\Core\Facades\Viartas;
use ViartasCore\Core\Models\BaseModel;
use ViartasCore\Core\Traits\DefinesAsCacheItem;
use ViartasCore\Core\Traits\HasMetaTags;

class Page extends BaseModel
{
    use DefinesAsCacheItem, HasMetaTags;

    /**
     * @var string[]
     */
    protected $fillable = [
        'title', 'content', 'slug',
        'user_id', 'page_id',
        'is_visible',
    ];

    /**
     * @var string
     */
    protected string $module = 'pages';

    /**
     * @var string
     */
    protected string $layout = 'default';

    /**
     * @var string
     */
    protected string $element_title = 'Page';

    /**
     * @return string
     */
    public function getParentKeyName(): string
    {
        return 'page_id';
    }

    /**
     * @return \Illuminate\Foundation\Application|View|Factory|Application
     */
    public function view(): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $app = Viartas::driver()->app()->current()->tag;
        //load views
        //check if template has
        //load view
        $element = $this;
        //make in base model, return app.module.default
        return theme_view($app.'.'.$this->module.'.'.$this->layout, compact('element'));
    }

    public function controller(): string
    {
        return 'ViartasModules\Pages\Controllers\Web\PagesController@index';
    }

    /**
     * @param string|null $locale
     * @return string
     */
    public function generateRoute(?string $locale = null): string
    {
        $segments = [];

        if ($locale) {
            if (Viartas::driver()->locale()->default()->tag != $locale) {
                $segments[] = $locale;
            }
        }

        //var_dump($segments);

        $child = $this->ancestorsAndSelf()->get()->toTree()->first();

        while ($child !== false) {
            $element = $child;

            if (! $locale) {
                $locale = Viartas::driver()->locale()->current()->tag;
            }

            $segments[] = $element->getTranslation('slug', $locale);

            if ($element->children->count()) {
                $child = $element->children->first();
            } else {
                $child = false;
            }
        }

        return implode('/', $segments);
    }
}
