<?php

use ViartasModules\Pages\Controllers\Accounting\PagesController;
use ViartasCore\Core\Facades\Route;

Route::prefix('pages')->group(function () {
    Route::get('/', [PagesController::class, 'index'])->name('pages.index');
    Route::get('/create', [PagesController::class, 'create'])->name('pages.create');
    Route::post('/create', [PagesController::class, 'store'])->name('pages.create');
    Route::get('/{id}/edit', [PagesController::class, 'edit'])->name('pages.edit');
    Route::post('/{id}/edit', [PagesController::class, 'update'])->name('pages.edit');
    Route::patch('/{id}/edit', [PagesController::class, 'updateOneField'])->name('pages.edit');
    Route::post('/{id}/destroy', [PagesController::class, 'destroy'])->name('pages.destroy');
    Route::get('/{id}/upload/images', [PagesController::class, 'uploadImages'])->name('pages.upload.images');
});
