<?php

namespace ViartasModules\CustomLinks\Tables\Accounting;

use ViartasBuilders\Tables\DataTables;
use ViartasBuilders\Tables\DataTablesButton;
use ViartasCore\Core\Facades\Viartas;
use ViartasModules\CustomLinks\Models\Accounting\CustomLink;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use ViartasBuilders\Tables\DataTablesRow;

class MenuCustomLinksTable extends DataTables
{
    public function __construct(Request $request)
    {
        parent::__construct(
            new CustomLink(),
            $request
        );

        $this->table();

        $this->addRows([
            $this->fieldId(),
            $this->fieldType(),
            $this->fieldTitle(),
            $this->fieldUrl(),
            $this->fieldUser(),
            $this->fieldSwitch([
                ['label' => __('Visible'), 'value' => "1",],
                ['label' => __('Invisible'), 'value' => "0",]
            ])
                ->field('is_visible')
                ->title(__('Visibility')),
            $this->fieldCheckboxMassActions(),
            $this->button()
                ->add($this->addOneItemButton())
                ->add((new DataTablesButton())->editButton()->setColor('warning'))
        ]);
    }

    public function addOneItemButton (): DataTablesButton
    {
        return (new DataTablesButton())
            ->setColor('primary')
            ->setTitle(__('Add one item'))
            ->setIcon('fa-plus-circle')
            ->setClass('add-one-menu-item')

            ->getRoute();
    }

    public function addManyItemsButton (): DataTablesButton
    {
        return (new DataTablesButton())
            ->setColor('primary')
            ->setTitle(__('Add many items button'))
            ->setIcon('fa-layer-group')
            ->setClass('add-one-menu-item-with-children')
            ->getRoute();
    }

    public function table(): self
    {
        $this->setRoute(route('accounting.menus.items.custom-links'));
        $this->setFilters(route('accounting.menus.items.custom-links'));
        $this->setId('custom-links-table');
        $this->setType('simple');
        $this->setClass('custom-links-table');
        $this->setTitle(__('Custom links'));
        $this->setIndexColumn('id');

        return $this;
    }

    public function fieldUrl(): DataTablesRow
    {
        $title = new DataTablesRow();

        $title->field('url')
            ->title(__('URL'))
            ->setSearchable()
            ->order(function (Builder $builder, string $direction) {
                $builder->orderBy('url->'.Viartas::driver()->locale()->current()->tag, $direction);
            });

        return $title;
    }

    public function fieldType(): DataTablesRow
    {
        $title = new DataTablesRow();

        $title->field('type')
            ->title(__('Type'))
            ->setSelectable();

        return $title;
    }
}
