<?php

namespace ViartasModules\CustomLinks\Tables\Accounting;

use ViartasBuilders\Tables\DataTables;
use ViartasBuilders\Tables\DataTablesButton;
use ViartasCore\Core\Facades\Viartas;
use ViartasModules\CustomLinks\Models\Accounting\CustomLink;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use ViartasBuilders\Tables\DataTablesRow;

class CustomLinksTable extends DataTables
{
    public function __construct(Request $request)
    {
        parent::__construct(
            new CustomLink(),
            $request
        );

        $this->table();

        $this->addRows([
            $this->fieldId(),
            $this->fieldType(),
            $this->fieldTitle(),
            $this->fieldUrl(),
            $this->fieldUser(),
            $this->fieldCreatedAt(),
            $this->fieldSwitch([
                ['label' => __('Visible'), 'value' => "1",],
                ['label' => __('Invisible'), 'value' => "0",]
            ])
            ->field('is_visible')
            ->title(__('Visibility')),
            $this->fieldCheckboxMassActions(),
            $this->button()
                ->add((new DataTablesButton())->editButton())
                ->add((new DataTablesButton())->destroyButton()),
        ]);
    }

    public function table(): self
    {
        $this->setRoute(route('accounting.custom-links.index'));
        $this->setFilters(route('accounting.custom-links.index'));
        $this->setId('custom-links-table');
        $this->setClass('custom-links-table');
        $this->setTitle(__('Custom links'));
        $this->setIndexColumn('id');

        return $this;
    }

    public function fieldUrl(): DataTablesRow
    {
        $title = new DataTablesRow();

        $title->field('url')
            ->title(__('URL'))
            ->setSearchable()
            ->order(function (Builder $builder, string $direction) {
                $builder->orderBy('url->'.Viartas::driver()->locale()->current()->tag, $direction);
            });

        return $title;
    }

    public function fieldType(): DataTablesRow
    {
        $title = new DataTablesRow();

        $title->field('type')
            ->title(__('Type'))
            ->setSelectable();

        return $title;
    }
}
