<?php

namespace ViartasModules\CustomLinks\Models\Accounting;

use ViartasCore\Core\Models\BaseModel;

class CustomLink extends BaseModel
{
    /**
     * @var string[]
     */
    protected $fillable = [
        'user_id',
        'title', 'url',
        'type', 'is_visible',
    ];

    /**
     * @var bool
     */
    protected bool $usesRecursiveRelations = false;

    /**
     * @var bool
     */
    protected bool $usesMedia = false;

    /**
     * @var string
     */
    protected string $module = 'custom-links';

    /**
     * @var string
     */
    protected string $element_title = 'Custom link';

    public function __construct()
    {
        parent::__construct();

        $this->translatable = array_merge($this->translatable, ['url']);
    }
}
