<?php

namespace ViartasModules\CustomLinks\Controllers\Accounting;

use ViartasCore\Core\Controllers\AccountingController;
use ViartasModules\CustomLinks\Forms\Accounting\CustomLinkEditForm;
use ViartasModules\CustomLinks\Models\Accounting\CustomLink;
use ViartasModules\CustomLinks\Tables\Accounting\CustomLinksTable;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class CustomLinksController extends AccountingController
{
    /**
     * @param CustomLinksTable $table
     * @param Request $request
     * @return string|array|View|\Illuminate\Foundation\Application|Factory|Application
     */
    public function index(CustomLinksTable $table, Request $request): string|array|View|\Illuminate\Foundation\Application|Factory|Application
    {
        return $this->tableBuilder(
            $table, $request, theme_view('accounting.custom-links.index', compact('table'))
        );
    }

    /**
     * @param CustomLinkEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function create(CustomLinkEditForm $form): View|Factory|Application|\Illuminate\Foundation\Application
    {
        return theme_view('accounting.custom-links.edit', [
            'form' => $form->build(),
            'element' => new CustomLink(),
        ]);
    }

    /**
     * @param CustomLinkEditForm $form
     * @return RedirectResponse
     */
    public function store(CustomLinkEditForm $form): RedirectResponse
    {
        $page = CustomLink::create($form->all());

        return theme_redirect()->route('accounting.custom-links.edit', [
            'id' => $page->id,
        ])->with('success', __('custom.link.created'));
    }

    /**
     * @param string $id
     * @param CustomLinkEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function edit(string $id, CustomLinkEditForm $form): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $page = CustomLink::findOrFail($id);
        $form = $form->setAction('update')->build($page);

        return theme_view('accounting.custom-links.edit', [
            'form' => $form,
            'element' => $page,
        ]);
    }

    /**
     * @param string $id
     * @param CustomLinkEditForm $form
     * @return RedirectResponse
     */
    public function update(string $id, CustomLinkEditForm $form): RedirectResponse
    {
        CustomLink::findOrFail($id)->update($form->all());

        return theme_redirect()->route('accounting.custom-links.edit', [
            'id' => $id,
        ])->with('success', __('custom.link.updated'));
    }

    /**
     * @param string $id
     * @param Request $request
     * @return void
     */
    public function updateOneField(string $id, Request $request): void
    {
        \App\Http\Controllers\Accounting\Page::findOrFail($id)->update([
            $request->get('field') => $request->get('value')
        ]);
    }

    /**
     * @param string $id
     * @param Request $request
     * @return bool|RedirectResponse
     */
    public function destroy(string $id, Request $request): bool|RedirectResponse
    {
        if ($id !== '0') {
            CustomLink::findOrFail($id)->delete();

            return theme_redirect()->route('accounting.custom-links.index')
                ->with('success', __('custom.link.deleted'));
        }

        $this->destroySelected($request);

        return true;
    }

    /**
     * @param Request $request
     * @return void
     */
    public function destroySelected(Request $request): void
    {
        foreach ($request->elements as $element) {
            CustomLink::find($element)->delete();
        }

        Session::flash('success', __('elements.selected.deleted'));
    }
}
