import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import commonjs from 'vite-plugin-commonjs';

export default defineConfig({
/*    define: {
        'window.$': 'window.jQuery = require("jquery")',
    },*/
    plugins: [
        laravel({
            hotFile: 'public/vendor/viartas-js/jquery/jquery.hot', // Most important lines
            buildDirectory: 'vendor/viartas-js/jquery', // Most important lines
            input: [
                'resources/js/jquery.js',
            ],
            refresh: true,

        }),
        commonjs(),

    ],
    optimizeDeps: {
        include: ['jquery'],
    },
    build: {
        rollupOptions: {
            output: {
                format: 'iife', // will allow type="text/javascript"
            },
        },
        commonjsOptions: {
            transformMixedEsModules: true
        },
    },
/*    resolve: {
        alias: {
            '$': 'jQuery'
        },
    },*/
});
