function setBtnLoading($btn, isLoading) {
    if (isLoading) {
        $btn.prop('disabled', true).attr('aria-disabled', 'true');
        $btn.find('.spinner-border').removeClass('d-none');
    } else {
        $btn.prop('disabled', false).removeAttr('aria-disabled');
        $btn.find('.spinner-border').addClass('d-none');
    }
}

function setBtnSaved($btn) {
    $btn.find('.spinner-border').addClass('d-none');
    $btn.removeClass('btn-primary').addClass('btn-success').prop('disabled', true);
    $btn.find('.btn-icon').removeClass('d-none');
}

function loadValidationRules() {

    let i = 0;
    let validator = [];
    let $form = [];
    let $submit = [];

    $(document).find(".backend-form-validator").each(function(){
        i ++;
        $form[i] = $(this);
        $submit[i] = $form[i].find(".modal-submit-button");

        validator[i] = $form[i].validate({
            errorElement: "span",
            errorClass: "text-danger small",
            highlight: (el)=>$(el).addClass("is-invalid"),
            unhighlight: (el)=>$(el).removeClass("is-invalid"),

            submitHandler: function(form, event) {
                event.preventDefault();
                setBtnLoading($submit[i], true);

                // Clear previous server errors (optional)
                validator[i].showErrors({});

                $.ajax({
                    url:  form.action,
                    type: form.method || 'POST',
                    data: $(form).serialize(),
                    headers: {
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // if posting to web.php route; not needed for sanctum/api tokens
                    },
                    success: function (resp) {
                        // Success UX – redirect, toast, reset form, etc.
                        // Example: reset and show a message
                        form.reset();
                        location.reload();
                        setBtnLoading($submit[i], false);
                        setBtnSaved($submit[i]);
                    },
                    error: function (xhr) {
                        if (xhr.status === 422 && xhr.responseJSON && xhr.responseJSON.errors) {
                            // Laravel format: { errors: { field: ["msg1","msg2"], ... } }
                            const laravelErrors = xhr.responseJSON.errors;

                            // Map to jQuery Validate format: { fieldName: "message" }
                            const jqErrors = {};
                            Object.keys(laravelErrors).forEach(field => {
                                // Show the first error per field (you can join if you want all)
                                jqErrors[field] = laravelErrors[field][0];
                            });

                            // Display all field errors at once
                            validator[i].showErrors(jqErrors);
                            setBtnLoading($submit[i], false);
                        } else {
                            // Non-validation error (500, 419, etc.)
                            alert('Unexpected error. Please try again.');
                            setBtnLoading($submit[i], false);
                        }
                    },
                    complete: function () {
                        // 👈 hide spinner + re-enable
                    }
                });
            }
        });
    });
}

$(function () {

    $('.load-data-for-edit').on('click', function () {
        $('.loaded-data').html();
        let url = $(this).data('url');
        $.ajax({
            async: false,
            url: url,
            type: 'GET',
            success: function (response) {
                $('.loaded-data').html(response);
            }
        });

        loadValidationRules();
    });

    loadValidationRules();
});
