<?php

namespace ViartasCore\Core\Traits;

use ViartasCore\Core\Models\Item;

trait DefinesAsItem
{
    /**
     * @var bool
     */
    public bool $definesAsItem = true;

    /*
     * Boot function from Laravel.
     */
    protected static function bootDefinesAsItem(): void
    {
        static::created(function ($model) {
            Item::create([
                'element' => $model->id,
                'class' => get_class($model),
            ]);
        });

        static::updated(function ($model) {

            $item = Item::query()
                ->where('element', $model->id)
                ->where('class', get_class($model->id))
                ->first();

            if (!$item) {
                Item::create([
                    'element' => $model->id,
                    'class' => get_class($model),
                ]);
            }
        });
    }
}
