<?php

namespace ViartasCore\Core\Traits;

use App\Facades\Asp;
use ViartasCore\Core\Facades\Viartas;
use ViartasCore\Core\Models\Item;

trait DefinesAsCacheItem
{
    /**
     * @var bool
     */
    public bool $definesAsItem = true;

    /**
     * @var array|string[]
     */
    protected static array $cacheable = [
        'title', 'slug', 'content',
    ];

    /**
     * @return array
     */
    protected static function cacheLocales(): array
    {
        return Viartas::driver()
            ->locale()
            ->all()
            ->pluck('tag')
            ->toArray();
    }

    /**
     * Boot function from Laravel.
     * @return void
     */
    protected static function bootDefinesAsCacheItem(): void
    {
        static::created(function ($model) {
            $item = Item::create([
                'element' => $model->id,
                'class' => get_class($model),
            ]);

            foreach (self::cacheLocales() as $locale) {
                foreach (self::$cacheable as $field) {
                    $data = [
                        'locale' => $locale,
                        'field' => $field,
                    ];

                    $cache = $item->cache()->create($data);

                    $data = self::getCacheFields($model, $locale, $field);

                    $cache->update($data);
                }
            }
        });

        static::updated(function ($model) {

            $item = Item::query()
                ->where('element', $model->id)
                ->where('class', get_class($model))
                ->first();

            if (!$item) {
                $item = Item::create([
                    'element' => $model->id,
                    'class' => get_class($model),
                ]);
            }

            foreach (self::cacheLocales() as $locale) {
                foreach (self::$cacheable as $field) {
                    $cache = $item->cache()
                        ->where('locale', $locale)
                        ->where('field', $field)
                        ->first();

                    $data = ['locale' => $locale, 'field' => $field];

                    if (!$cache) {
                        $cache = $item->cache()->create($data);
                    }

                    $data = self::getCacheFields($model, $locale, $field);

                    $cache->update($data);
                }
            }
        });
    }

    /**
     * @param $model
     * @param $locale
     * @param $field
     * @return array
     */
    public static function getCacheFields ($model, $locale, $field): array
    {
        $data = [];

        if (in_array($field, $model->fillable)) {

            $data['field'] = $field;
            $data['value'] = $model->{$field};
            if (method_exists($model, 'getTranslations')) {
                $translation = $model->getTranslations($field);

                if (isset($translation[$locale])) {
                    $data['value'] = $translation[$locale];
                }
            }
        }

        return $data;
    }
}
