<?php

namespace ViartasCore\Core\Tables;

use ViartasBuilders\Tables\DataTables;
use ViartasBuilders\Tables\DataTablesButton;
use ViartasBuilders\Tables\DataTablesRow;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use ViartasCore\Core\Models\Role;

class RolesTable extends DataTables
{
    public function __construct(Request $request)
    {
        parent::__construct(
            new Role(),
            $request
        );

        $this->table();

        $this->addRows([
            $this->fieldId(),
            (new DataTablesRow())->field('name')
                ->setSearchable()
                ->title(__('Role')),
            (new DataTablesRow())->field('guard_name')
                ->setSearchable()
                ->title(__('Guard')),
            $this->fieldCreatedAt(),
            $this->fieldCheckboxMassActions(),
            $this->button()
                ->add(
                    (new DataTablesButton())
                        ->setTitle(__('Permissions'))
                        ->setIcon('fa-shield')
                        ->setColor('success')
                        ->setRoute(function (Model $model) {
                            return $model->routePermissionsEdit();
                        })
                )
                ->add((new DataTablesButton())->editButton())
                ->add((new DataTablesButton())->destroyButton()),
        ]);
    }

    public function table(): self
    {
        $this->setRoute(route('accounting.roles.index'));
        $this->setFilters(route('accounting.roles.index'));
        $this->setId('roles-table');
        $this->setClass('roles-table');
        $this->setTitle(__('Accounting roles'));
        $this->setIndexColumn('id');

        return $this;
    }
}
