<?php

namespace ViartasCore\Core\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Route;
use ViartasCore\Core\Middleware\Authenticate;
use ViartasCore\Core\Middleware\RedirectIfAuthenticated;
use ViartasCore\Core\Middleware\RouteGuesser;
use ViartasCore\Core\Middleware\Theme;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     *
     * @return void
     */
    public function boot(): void
    {
        $router = $this->app['router'];

        $router->pushMiddlewareToGroup(
            'auth', Authenticate::class
        );

        $router->pushMiddlewareToGroup(
            'guest', RedirectIfAuthenticated::class
        );

        $router->pushMiddlewareToGroup(
            'theme', Theme::class
        );

        $router->pushMiddlewareToGroup(
            'routeGuesser', RouteGuesser::class
        );

        $this->configureRateLimiting();
    }

    /**
     * Configure the rate limiters for the application.
     *
     * @return void
     */
    protected function configureRateLimiting(): void
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });
    }
}
