<?php

namespace ViartasCore\Core\Providers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use ViartasCore\Core\Facades\Viartas;

class BladeServiceProvider extends ServiceProvider
{
    /**
     * @return void
     */
    public function boot(): void
    {
        $this->viteCssDirectives();
        $this->viteJsDirectives();
    }

    /**
     * @return void
     */
    public function viteCssDirectives(): void
    {
        Blade::directive('viteCssLibrary', function ($expression) {
            $parts = explode(',', $expression);
            $file = $parts[0];
            $vendor_path = $parts[1];

            Viartas::driver()->theme()->viteCssLibrary($file, $vendor_path);
        });

        Blade::directive('viteCssModule', function ($expression) {
            $parts = explode(',', $expression);
            $file = $parts[0];
            $vendor_path = $parts[1];

            Viartas::driver()->theme()->viteCssModule($file, $vendor_path);
        });

        Blade::directive('viteCssScript', function ($expression) {
            $parts = explode(',', $expression);
            $file = $parts[0];
            $vendor_path = $parts[1];

            Viartas::driver()->theme()->viteCssScript($file, $vendor_path);
        });
    }

    /**
     * @return void
     */
    public function viteJsDirectives(): void
    {

        Blade::directive('viteJsLibrary', function ($expression) {
            $parts = explode(',', $expression);
            $file = $parts[0];
            $vendor_path = $parts[1];

            Viartas::driver()->theme()->viteJsLibrary($file, $vendor_path);
        });

        Blade::directive('viteJsModule', function ($expression) {
            $parts = explode(',', $expression);
            $file = $parts[0];
            $vendor_path = $parts[1];

            Viartas::driver()->theme()->viteJsModule($file, $vendor_path);
        });

        Blade::directive('viteJsScript', function ($expression) {

        });
    }
}
