<?php

namespace ViartasCore\Core\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Segment extends BaseModel
{
    /**
     * @var string[]
     */
    protected $fillable = [
        'tag', 'title',
        'priority', 'is_active',
    ];

    /**
     * @return HasMany
     */
    public function applications(): HasMany
    {
        return $this->hasMany(Application::class);
    }

    /**
     * @return HasMany
     */
    public function appLocales(): HasMany
    {
        return $this->hasMany(Locale::class);
    }

    /**
     * @param $value
     * @return mixed
     */
    public function getDetected($value): mixed
    {
        $applications = $this->applications()
            ->available()
            ->get()
            ->where('tag', $value);

        $locales = $this->appLocales()
            ->available()
            ->get()
            ->where('tag', $value);

        return $applications->toBase()
            ->merge($locales)
            ->where('segment_id', $this->id)
            ->first();
    }

    /**
     * @return mixed
     */
    public function getDefault(): mixed
    {
        $applications = $this->applications()
            ->default()
            ->get();

        $locales = $this->appLocales()
            ->default()
            ->get();

        return $applications->toBase()
            ->merge($locales)
            ->where('segment_id', $this->id)
            ->first();
    }

    /**
     * @return Builder
     */
    public function scopeAvailable(): Builder
    {
        return $this->where('is_active', 1)
            ->orderBy('priority');
    }

    /**
     * @return Builder
     */
    public function scopeDefault(): Builder
    {
        return $this->where('is_default', 1);
    }
}
