<?php

namespace ViartasCore\Core\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class MenuItem extends BaseModel
{
    use HasFactory;

    /**
     * @var array
     */
    protected $fillable = [
        'user_id', 'menu_id', 'menu_item_id',
        'element', 'class',
        'sort', 'has_children',
    ];

    /**
     * @return string
     */
    public function getParentKeyName(): string
    {
        return 'menu_item_id';
    }

    /**
     * @return string
     */
    public function getLocalKeyName(): string
    {
        return 'id';
    }

    /**
     * @return HasMany
     */
    public function items(): HasMany
    {
        return $this->hasMany(MenuItem::class, 'menu_item_id', 'id')->where('menu_item_id', $this->id)->orderBy('sort');
    }

    /**
     * @return BelongsTo
     */
    public function item(): BelongsTo
    {
        return $this->belongsTo($this->class, 'element', 'id');
    }
}
