<?php

namespace ViartasCore\Core\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Application extends BaseModel
{
    /**
     * @var string[]
     */
    protected $fillable = [
        'tag', 'title',
        'is_default', 'is_active',
        'segment_id',
    ];

    /**
     * @return BelongsTo
     */
    public function segment(): BelongsTo
    {
        return $this->belongsTo(Segment::class);
    }

    /**
     * @return HasMany
     */
    public function themes(): HasMany
    {
        return $this->hasMany(Theme::class, 'application_id', 'id');
    }

    /**
     * @param $application
     * @return Builder
     */
    public function scopeApplication($application): Builder
    {
        return $this->where('tag', $application);
    }

    /**
     * @return Builder
     */
    public function scopeAvailable(): Builder
    {
        return $this->where('is_active', 1);
    }

    /**
     * @return Application
     */
    public function scopeDefault(): Application
    {
        return $this->available()
            ->where('is_default', 1)
            ->first();
    }

    /**
     * @return string
     */
    public function path(): string
    {
        return $this->is_default ? '' : $this->tag;
    }
}
