<?php

namespace ViartasCore\Core\Models;

use ViartasCore\Core\Drivers\RouteDriver;
use Illuminate\Support\Facades\Hash;

class AccountingUser extends BaseModel
{
    /**
     * @var string[]
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * @var bool
     */
    protected bool $usesRecursiveRelations = false;

    /**
     * @var bool
     */
    protected bool $usesMedia = false;

    /**
     * @var string
     */
    protected $table = 'users';

    /**
     * @var string
     */
    protected string $module = 'users';

    /**
     * @var string
     */
    protected string $element_title = 'User';

    /**
     * @return void
     */
    protected static function boot(): void
    {
        parent::boot();

        static::creating(function ($model) {
            $model->password = Hash::make($model->password);
        });

        static::updating(function ($model) {
            $model->password = Hash::make($model->password);
        });
    }

    /**
     * @return array
     */
    protected function menuConfig(): array
    {
        return [
            'edit' => $this->menuItem(__('Main settings'), $this->routeEdit()),
            'roles' => $this->menuItem(__('Roles'), $this->routeRolesEdit()),
            'activity' => $this->menuItem(__('Activity'), $this->routeEdit()),
        ];
    }

    /**
     * @return RouteDriver
     */
    public function routeRolesEdit (): RouteDriver
    {
        $route = sprintf('accounting.%s.roles.edit', $this->module);

        return new RouteDriver($route, [
            'id' => $this->id,
        ]);
    }

    /**
     * @return RouteDriver
     */
    public function routeRolesUpdate (): RouteDriver
    {
        $route = sprintf('accounting.%s.roles.update', $this->module);

        return new RouteDriver($route, [
            'id' => $this->id,
        ]);
    }
}
