<?php

namespace ViartasCore\Core\Forms\Users;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use Illuminate\Database\Eloquent\Collection;
use ViartasCore\Core\Models\Role;

class UserRolesForm extends Form
{
    private Collection $guards;

    public function __construct()
    {
        parent::__construct();

        $this->guards = Role::query()
            ->groupBy('guard_name')
            ->get();
    }
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form1',
            'class' => 'form',
            'action' => 'create',
            'routes' => [
                'create' => [
                    '_method' => 'POST',
                    'route' => 'accounting.users.roles.edit',
                    'routeAttributes' => [
                        'id' => 'id',
                    ],
                ],
                'update' => [
                    '_method' => 'POST',
                    'route' => 'accounting.users.roles.edit',
                    'routeAttributes' => [
                        'id' => 'id',
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        $response = [];

        foreach ($this->guards as $key => $guard) {

            $roles = Role::query()
                ->where('guard_name', $guard['guard_name'])
                ->get()
                ->pluck('name', 'id')
                ->toArray();

            $response[$guard['guard_name']] = [
                'roles['.$guard['guard_name'].'][]' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'options' => $roles,
                ],
                'save_'.$key => [
                    'title' => __('Save'),
                    'size' => '12',
                    'position' => 'text-end',
                    'class' => 'btn btn-success',
                    'type' => Field::BUTTON_SUBMIT,
                ],
            ];
        }

        return $response;
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        $response = [];

        foreach ($this->guards as $guard) {
            $response[$guard['guard_name']] = [
                'title' => 'Guard '. $guard['guard_name'].' '.__(' roles'),
                'layout' => Group::CARD,
                'size' => 4,
            ];
        }

        return $response;
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
