<?php

namespace ViartasCore\Core\Forms\Users;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use ViartasCore\Core\Models\AccountingUser;

class UserEditForm extends Form
{
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form1',
            'class' => 'form',
            'action' => 'create',
            'routes' => [
                'create' => [
                    'route' => 'accounting.users.create',
                    'routeAttributes' => [],
                ],
                'update' => [
                    '_method' => 'POST',
                    'route' => 'accounting.users.edit',
                    'routeAttributes' => [
                        'id' => 'id',
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        return [
            'group1' => [
                'name' => [
                    'title' => __('Username'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'required' => true,
                    'rules' => ['required', 'string', 'max:255', 'unique:users,name,id'],
                    'model' => AccountingUser::class,
                    'primary_key' => 'id',
                    'primary_value' => request()->id ?? false,
                ],
                'email' => [
                    'title' => __('Email'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'required' => true,
                    'rules' => ['required', 'string', 'email', 'max:255', 'unique:users,email,id'],
                    'model' => AccountingUser::class,
                    'primary_key' => 'id',
                    'primary_value' => request()->id ?? false,
                ],
                'password' => [
                    'title' => __('Password'),
                    'type' => Field::PASSWORD,
                    'size' => 12,
                    'confirmation' => true,
                    'model' => AccountingUser::class,
                ],
                'save' => [
                    'title' => __('Save'),
                    'size' => '12',
                    'position' => 'text-end',
                    'class' => 'btn btn-success',
                    'type' => Field::BUTTON_SUBMIT,
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        return [
            'group1' => [
                'title' => __('User login data'),
                'layout' => Group::CARD,
                'size' => 12,
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
