<?php

namespace ViartasCore\Core\Forms\Roles;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Route;
use Spatie\Permission\Models\Permission;
use ViartasCore\Core\Models\Locale;
use ViartasCore\Core\Models\Role;

class RolesPermissionsForm extends Form
{
    private Collection $guards;

    /**
     * @var array|string[]
     */
    protected array $blacklist = [
        'login', 'logout', 'password',
    ];

    public function __construct()
    {
        parent::__construct();

        $this->guards = Role::query()
            ->groupBy('guard_name')
            ->get();

        $this->blacklist = array_merge($this->blacklist, Locale::query()->pluck('tag')->toArray());
    }

    /**
     * @param string $guard
     * @return array
     */
    public function appRoutes(string $guard): array
    {
        $permissions = [];
        $response = [];
        $routes = Route::getRoutes();

        foreach ($routes as $route) {

            if (preg_match('/^('.$guard.')\./', $route->getName())) {
                $parts = explode(".", $route->getName());
                $guard = $parts[0];
                $module = $parts[1];

                unset($parts[0]);
                unset($parts[1]);

                if (count($parts) && !in_array($module, $this->blacklist) && !in_array($guard, $this->blacklist)) {
                    $permission = implode(".", $parts);
                    $response[$guard][$module][$route->getName()] = $permission;

                    $permissions[$guard][] = $route->getName();
                }
            }
        }

        //var_dump($permissions);

        foreach ($permissions as $route_guard => $routes) {
            foreach ($routes as $route) {
                Permission::findOrCreate($route, $route_guard);
            }
        }

        return $response[$guard] ?? [];
    }

    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form1',
            'class' => 'form',
            'action' => 'create',
            'routes' => [
                'update' => [
                    '_method' => 'POST',
                    'route' => 'accounting.roles.permissions.edit',
                    'routeAttributes' => [
                        'id' => 'id',
                    ],
                ],
                'create' => [
                    '_method' => 'POST',
                    'route' => '',
                    'routeAttributes' => [

                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        $response = [];

        $role = Role::findOrFail(request()->id);

        $permissions = $this->appRoutes($role->guard_name);

        foreach ($permissions as $module => $permission) {

            $response[$module] = [
                'roles[' . $module . '][]' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'inline' => true,
                    'options' => $permission,
                ],
                'save_' . $module => [
                    'title' => 'Save',
                    'size' => '12',
                    'position' => 'text-end',
                    'class' => 'btn btn-success',
                    'type' => Field::BUTTON_SUBMIT,
                ],
            ];
        }

        return $response;
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        $response = [];

        $role = Role::findOrFail(request()->id);
        $permissions = $this->appRoutes($role->guard_name);

        foreach ($permissions as $module => $permission) {
            $response[$module] = [
                'title' => 'Module '. $module.' '.__(' routes'),
                'layout' => Group::CARD,
                'size' => 4,
            ];
        }

        return $response;
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
