<?php

namespace ViartasCore\Core\Forms\Menus;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use ViartasCore\Core\Models\Menu;

class MenuEditForm extends Form
{
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form1',
            'class' => 'form',
            'action' => 'create',
            'routes' => [
                'create' => [
                    'route' => 'accounting.menus.create',
                    'routeAttributes' => [],
                ],
                'update' => [
                    '_method' => 'POST',
                    'route' => 'accounting.menus.edit',
                    'routeAttributes' => [
                        'id' => 'id',
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        return [
            'group1' => [
                'tag' => [
                    'title' => __('Short tag'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'rules' => ['string', 'max:255', 'unique:menus,tag,id'],
                    'model' => Menu::class,
                    'primary_key' => 'id',
                    'primary_value' => request()->id ?? false,
                ],
                'title' => [
                    'title' => __('Title'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'translatable' => true,
                    'required' => true,
                ],
            ],
            'group2' => [
                'guard' => [
                    'title' => __('Guard'),
                    'type' => Field::SELECT,
                    'size' => 12,
                    'required' => true,
                    'options' => [
                        'web' => 'web',
                        'accounting' => 'accounting',
                        'api' => 'api',
                        'b2b' => 'b2b',
                    ]
                ],
                'depth' => [
                    'title' => __('Depth'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'required' => true,
                    'rules' => ['int', 'max:10'],
                ],
                'class' => [
                    'title' => 'Class',
                    'type' => Field::TEXT,
                    'size' => 12,
                ],
                'is_visible' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'options' => [
                        '1' => __('Visible'),
                    ],
                ],
                'save' => [
                    'title' => __('Save'),
                    'size' => '12',
                    'position' => 'text-end',
                    'class' => 'btn btn-success',
                    'type' => Field::BUTTON_SUBMIT,
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        return [
            'group1' => [
                'title' => 'Menu content',
                'layout' => Group::CARD,
                'size' => 8,
            ],
            'group2' => [
                'title' => 'Menu settings',
                'layout' => Group::CARD,
                'size' => 4,
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
