<?php

namespace ViartasCore\Core\Facades;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Routing\RouteRegistrar;
use Illuminate\Support\Facades\Route as BaseRoute;
use Spatie\TranslationLoader\LanguageLine;
use ViartasCore\Core\Models\Locale;

class Route extends BaseRoute
{
    /**
     * @param $uri
     * @param $action
     * @return \Illuminate\Routing\Route
     */
    public static function get($uri, $action = null): \Illuminate\Routing\Route
    {
        $uri = static::translateRoute($uri);

        // Custom route definition logic
        return parent::get($uri, $action);
    }

    /**
     * @param string $prefix
     * @return RouteRegistrar
     */
    public static function prefix(string $prefix): RouteRegistrar
    {
        $prefix = static::translateRoute($prefix);
        return parent::prefix($prefix); // TODO: Change the autogenerated stub
    }

    public static function translateRoute($uri): string
    {
        //return str_replace('edit', 'redaguoti', $uri);
        $translated = [];

        $parts = explode("/", $uri);
        foreach ($parts as $segment) {

            if (preg_match('/(?<=\{)(.+)(?=\})/is', $segment)) {
                $translated[] = $segment;
                continue;
            }

            if ($segment == '') {
                $translated[] = $segment;
                continue;
            }

            $translation = trans('route.'.$segment);

            if ($translation == 'route.'.$segment) {

                $exists = LanguageLine::query()
                    ->where('group', 'route')
                    ->where('key', $segment)
                    ->first();

                if (!$exists) {
                    LanguageLine::create([
                        'group' => 'route',
                        'key' => $segment,
                        'text' => ['en' => $segment, 'lt' => $segment, 'ru' => $segment],
                    ]);
                }

                LanguageLine::first()->touch();
                $translated[] = $segment;
                continue;
            }

            LanguageLine::first()->touch();
            $translated[] = $translation;
        }

        return implode('/', $translated);
    }

    function r (string $group, string $route): string
    {
        $translated = [];

        foreach (explode("/", $route) as $segment) {
            if (!preg_match('/(?<=\{)(.+)(?=\})/is', $segment) && $segment != '') {
                $translated[] = \Viartas\Viartas\Facades\Viartas::locale()->translateGlobals('route', $group, $segment);
            }
        }

        return implode('/', $translated);
    }

    /**
     * @param Locale $locale
     * @param Model|null $model
     * @return string
     */
    public static function switch(Locale $locale, ?Model $model = null): string
    {
        if ($model) {
            return '/' . $model->generateRoute($locale->tag);
        }

        return self::module($locale);
    }

    /**
     * @param Locale $locale
     * @return string
     */
    public static function module(Locale $locale): string
    {
        $route = self::currentRouteName();
        $app = self::app();

        $app_pattern = sprintf('/^(%s)\./', self::app());
        $locale_pattern = sprintf('/^(%s)\./', self::locale());

        $route = preg_replace($app_pattern, '', $route);
        $route = preg_replace($locale_pattern, '', $route);

        if ($locale->is_default) {
            return route($app.'.'.$route);
        }

        return route($app.'.'.$locale->tag.'.'.$route);
    }

    /**
     * @return Collection
     */
    public static function locales(): Collection
    {
        return Viartas::driver()->locale()->all();
    }

    /**
     * @return string
     */
    public static function locale(): string
    {
        return Viartas::driver()->locale()->current()->tag;
    }

    /**
     * @return Locale
     */
    public static function currentLocale(): Locale
    {
        return Viartas::driver()->locale()->current();
    }

    /**
     * @return string
     */
    public static function app(): string
    {
        return Viartas::driver()->app()->current()->tag;
    }

    /**
     * @return string
     */
    public static function localeSlug(): string
    {
        return static::currentLocale()->is_default ? '/' : '/'.static::locale();
    }
}
