<?php

namespace ViartasCore\Core\Drivers;

class Driver
{
    /**
     * @var AppDriver
     */
    protected AppDriver $appDriver;

    /**
     * @var LocaleDriver
     */
    protected LocaleDriver $localeDriver;

    /**
     * @var ThemeDriver
     */
    protected ThemeDriver $themeDriver;

    /**
     *
     */
    public function __construct()
    {
        $this->boot();
    }

    /**
     * @return void
     */
    private function boot(): void
    {
        $this->appDriver = new AppDriver();
        $this->localeDriver = new LocaleDriver($this->appDriver->locale());
    }

    /**
     * @return AppDriver
     */
    public function app(): AppDriver
    {
        return $this->appDriver ?? $this->appDriver = new AppDriver();
    }

    /**
     * @return LocaleDriver
     */
    public function locale(): LocaleDriver
    {
        return $this->localeDriver ?? $this->localeDriver = new LocaleDriver($this->app()->locale());
    }

    /**
     * @return RouteDriver
     */
    public function routes(): RouteDriver
    {
        return new RouteDriver();
    }

    /**
     * @return ThemeDriver
     */
    public function theme(): ThemeDriver
    {
        return $this->themeDriver ?? $this->themeDriver = new ThemeDriver($this->app()->current());
    }

    /**
     * @return RedirectDriver
     */
    public function redirect(): RedirectDriver
    {
        return app(RedirectDriver::class);
    }

    /**
     * @return InstallDriver
     */
    public function install(): InstallDriver
    {
        return new InstallDriver();
    }
}
