<?php

namespace ViartasCore\Core\Controllers;

use App\Http\Controllers\Controller;
use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Client\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Spatie\Permission\Models\Role;
use ViartasBuilders\Tables\Traits\HasTable;
use ViartasCore\Core\Facades\Viartas;

class WebController extends Controller
{
    use HasTable;

    /**
     * @var string
     */
    protected string $guard = 'web';

    /**
     *
     */
    public function __construct()
    {
        if (app()->runningInConsole()) {
            return;
        }

        $guard = $this->guard;

        $has_permission = false;
        $route = request()->route();

        if (Auth::Guest()) {
            $guestRole = Role::findByName('guest');
            $has_permission = $guestRole->hasPermissionTo($route->getAction()['as'], $this->guard);
        }

        if (! $has_permission) {

            $this->middleware(['auth', function ($request, $next) use ($guard, $route) {
                $user = (Auth::user() ?? abort(403));

                if ($user->hasRole('admin')) {
                    return $next($request);
                }

                if ($user->hasPermissionTo($route->getAction()['as'], $guard)) {
                    return $next($request);
                }

                abort(403);
            }]);
        }

        $this->middleware(['theme', function ($request, Closure $next) {

            $route = $request->route();
            $routeControllerParts = explode('@', $route->getAction()['controller']);

            $routeController = $routeControllerParts[0];
            $routeMethod = $routeControllerParts[1];

            $themeControllers = Viartas::driver()->theme()->controllers();

            if (isset($themeControllers[$routeController])) {

                $themeController = $themeControllers[$routeController] . '@' . $routeMethod;

                $routeAction = array_merge($route->getAction(), [
                    'uses'       => $themeController,
                    'controller' => $themeController,
                ]);

                $route->setAction($routeAction);
                $route->controller = false;
            }

            return $next($request);
        }]);
    }
}
