<?php

namespace ViartasCore\Core\Controllers\RouteGuessers;

use App\Http\Controllers\Controller;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Models\Role;
use ViartasCore\Core\Facades\Viartas;

class WebRouteGuesserController extends Controller
{
    protected string $guard = 'web';

    public function __construct()
    {
        if (app()->runningInConsole()) {
            return;
        }

        $request = request();
        $packageGuessers = Viartas::driver()->app()->getPackagesRouteGuessers();

        $error = false;
        $found = false;

        foreach ($packageGuessers as $packageGuesser) {

            if ($found) {
                break;
            }

            $route = $packageGuesser->guessRoute($request);

            if (is_int($route)) {
                $error = $route;
            } else {
                $found = true;
                $model = $route;
                $moduleController = $model->controller();

                $route = $request->route();
                $id = $request->route('element') ?? $model->id;

                $route->setParameter('element', $id);

                $routeAction = array_merge($route->getAction(), [
                    'uses'       => $moduleController,
                    'controller' => $moduleController,
                    'as' => 'web.'.$model->getModule().'.index',
                    'original_route' => $route->getAction()['as'],
                ]);
            }
        }

        if(! $found ) {
            abort($error);
        }

        $guard = $this->guard;
        $has_permission = false;

        if (Auth::Guest()) {
            $guestRole = Role::findByName('guest');
            $has_permission =
                $guestRole->hasPermissionTo($routeAction['as'], $this->guard) && $guestRole->hasPermissionTo($routeAction['original_route'], $this->guard);
        }


        if (! $has_permission) {
            $this->middleware(['auth', function ($request, $next) use ($guard, $route, $routeAction) {
                $user = (Auth::user() ?? abort(403));

                if ($user->hasRole('admin')) {
                    return $next($request);
                }

                if ($user->hasPermissionTo($routeAction['as'], $guard) && $user->hasPermissionTo($routeAction['original_route'], $guard)) {
                    return $next($request);
                }

                abort(403);
            }]);
        }

        $this->middleware(['routeGuesser', function ($request, Closure $next) use ($routeAction) {
            $route = $request->route();
            $route->setAction($routeAction);
            $route->controller = false;
            return $next($request);
        }]);

        //parent::__construct();
    }

    public function guessRoute(Request $request): void
    {

    }
}
