<?php

namespace ViartasCore\Core\Controllers;

use ViartasCore\Core\Forms\Common\ImagesUploadForm;
use ViartasCore\Core\Forms\Modules\MetaEditForm;
use ViartasCore\Core\Forms\Modules\ModuleActionEditForm;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use ViartasCore\Core\Models\Meta;
use ViartasCore\Core\Models\Module;
use ViartasCore\Core\Models\ModuleAction;

class ModulesActionsController extends AccountingController
{
    /**
     * @param string $id
     * @param string $action
     * @param ModuleActionEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function edit(string $id, string $action, ModuleActionEditForm $form): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $moduleAction = ModuleAction::findOrFail($action);
        $form = $form->setAction('update')->build($moduleAction);

        $module = Module::findOrFail($id);
        $module->currentAction($moduleAction);

        return theme_view('accounting.modules.actions.edit', [
            'form' => $form,
            'element' => $module,
            'action' => $moduleAction,
        ]);
    }

    /**
     * @param string $id
     * @param string $action
     * @param ModuleActionEditForm $form
     * @return RedirectResponse
     */
    public function update(string $id, string $action, ModuleActionEditForm $form): RedirectResponse
    {
        ModuleAction::findOrFail($action)->update($form->all());

        return theme_redirect()->route('accounting.modules.actions.edit', [
            'id' => $id,
            'action' => $action,
        ])->with('success', __('module.view.updated'));
    }

    /**
     * @param string $id
     * @param string $action
     * @param Request $request
     * @return void
     */
    public function updateOneField(string $id, string $action, Request $request): void
    {
        ModuleAction::findOrFail($action)->update([
            $request->get('field') => $request->get('value')
        ]);
    }

    /**
     * @param string $id
     * @param string $class
     * @param MetaEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function editMeta(string $id, string $class, MetaEditForm $form): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $class = base64_decode($class);
        $element = $class::findOrFail($id);

        if (!$element->meta()->first()) {
            Meta::create([
                'element' => $id,
                'class' => $class,
            ]);

            $element->refresh();
        }

        $form = $form->setAction('update')->build($element->meta()->first());

        return theme_view('accounting.modules.actions.meta', [
            'form' => $form,
            'element' => $element,
        ]);
    }

    /**
     * @param string $id
     * @param string $class
     * @param MetaEditForm $form
     * @return RedirectResponse
     */
    public function updateMeta(string $id, string $class, MetaEditForm $form): RedirectResponse
    {
        $meta = Meta::findOrFail($id);
        $meta->update($form->all());

        return theme_redirect()->route('accounting.modules.meta.edit', [
            'id' => $meta->element,
            'class' => base64_encode($meta->class),
        ])->with('success', __('meta.updated'));
    }

    /**
     * @param $id
     * @param ImagesUploadForm $images
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function uploadImages($id, ImagesUploadForm $images): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $module = Module::findOrFail($id);
        $images = $images->build();

        $images->field('images')
            ->setModel(Module::class)
            ->setPrimaryKey('id')
            ->setPrimaryValue($id);

        return theme_view('accounting.modules.common', [
            'form' => $images,
            'element' => $module,
        ]);
    }

}
