<?php

namespace ViartasCore\Core\Controllers;

use App\Http\Controllers\Controller;
use Closure;
use ViartasBuilders\Tables\Traits\HasTable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use ViartasCore\Core\Facades\Viartas;

class AccountingController extends Controller
{
    use HasTable;

    /**
     * @var string
     */
    protected string $guard = 'accounting';

    /**
     *
     */
    public function __construct()
    {
        $guard = $this->guard;

        $this->middleware(['auth', function ($request, $next) use ($guard) {
            $user = (Auth::user() ?? abort(403));
            if ($user->hasRole('admin')) {
                return $next($request);
            }

            if ($user->hasPermissionTo(Route::currentRouteName(), $guard)) {
                return $next($request);
            }

            abort(403);
        }]);

        $this->middleware(['theme', function ($request, Closure $next) {

            $route = $request->route();
            $routeControllerParts = explode('@', $route->getAction()['controller']);

            $routeController = $routeControllerParts[0];
            $routeMethod = $routeControllerParts[1];

            $themeControllers = Viartas::driver()->theme()->controllers();

            if (isset($themeControllers[$routeController])) {

                $themeController = $themeControllers[$routeController] . '@' . $routeMethod;

                $routeAction = array_merge($route->getAction(), [
                    'uses'       => $themeController,
                    'controller' => $themeController,
                ]);

                $route->setAction($routeAction);
                $route->controller = false;
            }

            return $next($request);
        }]);
    }
}
