<?php

namespace ViartasCore\Core\Commands\Users;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Auth;

class UserCreateTokenCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'api:user-token-create {--email=} {--pass=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        if (
            Auth::attempt([
                'email' => $this->option('email'),
                'password' => $this->option('pass')
            ])
        ) {
            $user = Auth::user();
            $success['token'] =  $user->createToken('Updates')->plainTextToken;
            $success['name'] =  $user->name;

            $this->comment('Token: '.$success['token']);
        }
        else {
            $this->comment('Unauthorised');
        }
    }
}
