<?php

namespace ViartasCore\Core\Commands\Users;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;
use ViartasCore\Core\Models\User;

class UserCreateNew extends Command
{
    protected $signature = 'user:create {--name=} {--email=} {--password=}';

    public function handle()
    {
        User::create([
            'name' => $this->option('name'),
            'email' => $this->option('email'),
            'password' => Hash::make($this->option('password')),
        ]);
    }
}
