<?php

namespace ViartasCore\Core\Commands\Content;

use Illuminate\Console\Command;
use Spatie\Permission\Models\Permission;
use ViartasCore\Core\Facades\Viartas;
use ViartasCore\Core\Forms\Roles\RolesPermissionsForm;
use ViartasCore\Core\Models\Item;
use ViartasCore\Core\Models\Menu;
use ViartasCore\Core\Models\ModuleAction;
use ViartasCore\Core\Models\Role;
use ViartasCore\Core\Models\User;
use ViartasCore\Core\Tables\ModulesTable;
use ViartasModules\CustomLinks\Models\Accounting\CustomLink;
use ViartasModules\Pages\Models\Accounting\Page;
use ViartasModules\PostCategories\Models\Accounting\PostCategory;
use ViartasModules\Posts\Models\Accounting\Post;
use ViartasShop\Attributes\Models\Accounting\Attribute;
use ViartasShop\Attributes\Models\Accounting\AttributeGroup;
use ViartasShop\Brands\Models\Accounting\Brand;
use ViartasShop\Brands\Models\Accounting\Model;
use ViartasShop\ProductCategories\Models\Accounting\ProductCategory;

class GenerateDefault extends Command
{
    /**
     * @var string
     */
    protected $signature = 'content:generate';

    /**
     * @var array
     */
    private array $sameData = [];

    /**
     * @var array|array[]
     */
    private array $modules = [
        'accounting.dashboard.index' => ['title' => ['en' => 'Dashboard', 'lt' => 'Prietaisų skydelis', 'ru' => 'Панель управления']],
        'accounting.users.index' => ['title' => ['en' => 'Users', 'lt' => 'Vartotojai', 'ru' => 'Пользователи']],
        'accounting.users.create' => ['title' => ['en' => 'Create user', 'lt' => 'Sukurti vartotoją', 'ru' => 'Создать пользователя']],
        'accounting.users.edit' => ['title' => ['en' => 'Edit user', 'lt' => 'Redaguoti vartotoją', 'ru' => 'Редактировать пользователя']],
        'accounting.users.roles.edit' => ['title' => ['en' => 'Edit users roles', 'lt' => 'Redaguoti vartotojų roles', 'ru' => 'Редактировать роли пользователей']],
        'accounting.roles.index' => ['title' => ['en' => 'Roles', 'lt' => 'Roles', 'ru' => 'Роли']],
        'accounting.roles.create' => ['title' => ['en' => 'Create role', 'lt' => 'Sukurti rolę', 'ru' => 'Создать роль']],
        'accounting.roles.edit' => ['title' => ['en' => 'Edit role', 'lt' => 'Redaguoti rolę', 'ru' => 'Редактировать роль']],
        'accounting.roles.permissions.edit' => ['title' => ['en' => 'Edit roles permissions', 'lt' => 'Redaguoti rolių teises', 'ru' => 'Редактировать разрешения ролей']],
        'accounting.modules.index' => ['title' => ['en' => 'Modules', 'lt' => 'Moduliai', 'ru' => 'Модули']],
        'accounting.modules.edit' => ['title' => ['en' => 'Edit module', 'lt' => 'Redaguoti modulį', 'ru' => 'Редактировать модуль']],
        'accounting.modules.actions' => ['title' => ['en' => 'Modules actions', 'lt' => 'Modulių veiksmai', 'ru' => 'Действия модулей']],
        'accounting.modules.actions.edit' => ['title' => ['en' => 'Edit modules actions', 'lt' => 'Redaguoti modulių veiksmus', 'ru' => 'Редактировать действия модулей']],
        'accounting.modules.upload.images' => ['title' => ['en' => 'Upload modules images', 'lt' => 'Įkelti modulių nuotraukas', 'ru' => 'Загрузить изображения модулей']],
        'accounting.menus.index' => ['title' => ['en' => 'Menus', 'lt' => 'Meniu', 'ru' => 'Меню']],
        'accounting.menus.create' => ['title' => ['en' => 'Create menu', 'lt' => 'Sukurti meniu', 'ru' => 'Создать меню']],
        'accounting.menus.edit' => ['title' => ['en' => 'Edit menu', 'lt' => 'Redaguoti meniu', 'ru' => 'Редактировать меню']],
        'accounting.menus.list' => ['title' => ['en' => 'Menus list', 'lt' => 'Meniu sąrašas', 'ru' => 'Список меню']],
        'accounting.menus.history' => ['title' => ['en' => 'Menus history', 'lt' => 'Meniu istorija', 'ru' => 'История меню']],
        'accounting.menus.items.modules' => ['title' => ['en' => 'Module items for menu', 'lt' => 'Modulių elementai meniu', 'ru' => 'Элементы модуля для меню']],
        'accounting.menus.items.pages' => ['title' => ['en' => 'Pages items for menu', 'lt' => 'Puslapių elementai meniu', 'ru' => 'Элементы страниц для меню']],
        'accounting.menus.items.post-categories' => ['title' => ['en' => 'Post categories items for menu', 'lt' => 'Paskelbimo kategorijų elementai meniu', 'ru' => 'Элементы категорий постов для меню']],
        'accounting.menus.items.custom-links' => ['title' => ['en' => 'Custom Links items for menu', 'lt' => 'Pritaikyti nuorodų elementai meniu', 'ru' => 'Элементы пользовательских ссылок для меню']],
        'accounting.custom-links.index' => ['title' => ['en' => 'Custom links', 'lt' => 'Pritaikytos nuorodos', 'ru' => 'Пользовательские ссылки']],
        'accounting.custom-links.create' => ['title' => ['en' => 'Create custom link', 'lt' => 'Sukurti pritaikytą nuorodą', 'ru' => 'Создать пользовательскую ссылку']],
        'accounting.custom-links.edit' => ['title' => ['en' => 'Edit custom link', 'lt' => 'Redaguoti pritaikytą nuorodą', 'ru' => 'Редактировать пользовательскую ссылку']],
        'accounting.pages.index' => ['title' => ['en' => 'Pages', 'lt' => 'Puslapiai', 'ru' => 'Страницы']],
        'accounting.pages.create' => ['title' => ['en' => 'Create page', 'lt' => 'Sukurti puslapį', 'ru' => 'Создать страницу']],
        'accounting.pages.edit' => ['title' => ['en' => 'Edit page', 'lt' => 'Redaguoti puslapį', 'ru' => 'Редактировать страницу']],
        'accounting.pages.upload.images' => ['title' => ['en' => 'Upload pages images', 'lt' => 'Įkelti puslapių nuotraukas', 'ru' => 'Загрузить изображения страниц']],
        'accounting.post-categories.index' => ['title' => ['en' => 'Post categories', 'lt' => 'Paskelbimo kategorijos', 'ru' => 'Категории постов']],
        'accounting.post-categories.create' => ['title' => ['en' => 'Create post category', 'lt' => 'Sukurti paskelbimo kategoriją', 'ru' => 'Создать категорию поста']],
        'accounting.post-categories.edit' => ['title' => ['en' => 'Edit post category', 'lt' => 'Redaguoti paskelbimo kategoriją', 'ru' => 'Редактировать категорию поста']],
        'accounting.post-categories.upload.images' => ['title' => ['en' => 'Upload post categories images', 'lt' => 'Įkelti paskelbimo kategorijų nuotraukas', 'ru' => 'Загрузить изображения категорий постов']],
        'accounting.posts.index' => ['title' => ['en' => 'Posts', 'lt' => 'Paskelbimai', 'ru' => 'Посты']],
        'accounting.posts.create' => ['title' => ['en' => 'Create post', 'lt' => 'Sukurti paskelbimą', 'ru' => 'Создать пост']],
        'accounting.posts.edit' => ['title' => ['en' => 'Edit post', 'lt' => 'Redaguoti paskelbimą', 'ru' => 'Редактировать пост']],
        'accounting.posts.upload.images' => ['title' => ['en' => 'Upload posts images', 'lt' => 'Įkelti paskelbimų nuotraukas', 'ru' => 'Загрузить изображения постов']],
        'accounting.empty.route' => ['title' => ['en' => 'Empty route', 'lt' => 'Tuščias maršrutas', 'ru' => 'Пустой маршрут']],
        'accounting.any.index' => ['title' => ['en' => 'Any route', 'lt' => 'Bet koks maršrutas', 'ru' => 'Любой маршрут']],
        'web.main-page.index' => ['title' => ['en' => 'Main page', 'lt' => 'Pagrindinis puslapis', 'ru' => 'Главная страница']],
        'web.pages.index' => ['title' => ['en' => 'Pages', 'lt' => 'Puslapiai', 'ru' => 'Страницы']],
        'web.post-categories.index' => ['title' => ['en' => 'Post categories', 'lt' => 'Paskelbimo kategorijos', 'ru' => 'Категории постов']],
        'web.any.index' => ['title' => ['en' => 'Any route', 'lt' => 'Bet koks maršrutas', 'ru' => 'Любой маршрут']],
        'accounting.meta.edit' => ['title' => ['en' => 'Edit meta', 'lt' => 'Redaguoti meta', 'ru' => 'Редактировать мета']],
        'accounting.modules.list' => ['title' => ['en' => 'Modules list', 'lt' => 'Modulių sąrašas', 'ru' => 'Список модулей']],
        'accounting.modules.meta.edit' => ['title' => ['en' => 'Edit modules meta', 'lt' => 'Redaguoti modulių meta', 'ru' => 'Редактировать мета модулей']],
        'accounting.modules.meta-edit' => ['title' => ['en' => 'Edit modules meta', 'lt' => 'Redaguoti modulių meta', 'ru' => 'Редактировать мета модулей']],

        //shop
        'accounting.product-categories.index' => ['title' => ['en' => 'Product categories', 'lt' => 'Prekių kategorijos', 'ru' => 'Категории товаров']],
        'accounting.product-categories.create' => ['title' => ['en' => 'Create product category', 'lt' => 'Sukurti prekių kategoriją', 'ru' => 'Создать категорию товара']],
        'accounting.product-categories.edit' => ['title' => ['en' => 'Edit product category', 'lt' => 'Redaguoti prekių kategoriją', 'ru' => 'Редактировать категорию товара']],
        'accounting.product-categories.upload.images' => ['title' => ['en' => 'Upload product categories images', 'lt' => 'Įkelti prekių kategorijų nuotraukas', 'ru' => 'Загрузить изображения категорий товаров']],
        'accounting.products.index' => ['title' => ['en' => 'Products', 'lt' => 'Prekės', 'ru' => 'Товары']],
        'accounting.products.create' => ['title' => ['en' => 'Create product', 'lt' => 'Sukurti prekę', 'ru' => 'Создать товар']],
        'accounting.products.edit' => ['title' => ['en' => 'Edit product', 'lt' => 'Redaguoti prekę', 'ru' => 'Редактировать товар']],
        'accounting.products.upload.images' => ['title' => ['en' => 'Upload products images', 'lt' => 'Įkelti prekių nuotraukas', 'ru' => 'Загрузить изображения товаров']],

        'accounting.brands.index' => ['title' => ['en' => 'Brands', 'lt' => 'Prekių ženklai', 'ru' => 'Бренды']],
        'accounting.brands.create' => ['title' => ['en' => 'Create brand', 'lt' => 'Sukurti prekės ženklą', 'ru' => 'Создать бренд']],
        'accounting.brands.edit' => ['title' => ['en' => 'Edit brand', 'lt' => 'Redaguoti prekės ženklą', 'ru' => 'Редактировать бренд']],
        'accounting.brands.upload.images' => ['title' => ['en' => 'Upload brands images', 'lt' => 'Įkelti prekės ženklų nuotraukas', 'ru' => 'Загрузить изображения брендов']],

        'accounting.models.index' => ['title' => ['en' => 'Models', 'lt' => 'Modeliai', 'ru' => 'Модели']],
        'accounting.models.create' => ['title' => ['en' => 'Create model', 'lt' => 'Sukurti modelį', 'ru' => 'Создать модель']],
        'accounting.models.edit' => ['title' => ['en' => 'Edit model', 'lt' => 'Redaguoti modelį', 'ru' => 'Редактировать модель']],
        'accounting.models.upload.images' => ['title' => ['en' => 'Upload models images', 'lt' => 'Įkelti modelių nuotraukas', 'ru' => 'Загрузить изображения моделей']],

        'accounting.attributes.index' => ['title' => ['en' => 'Attributes', 'lt' => 'Atributai', 'ru' => 'Атрибуты']],
        'accounting.attributes.create' => ['title' => ['en' => 'Create attribute', 'lt' => 'Sukurti atributą', 'ru' => 'Создать атрибут']],
        'accounting.attributes.edit' => ['title' => ['en' => 'Edit attribute', 'lt' => 'Redaguoti atributą', 'ru' => 'Редактировать атрибут']],
        'accounting.attributes.upload.images' => ['title' => ['en' => 'Upload attributes images', 'lt' => 'Įkelti atributų nuotraukas', 'ru' => 'Загрузить изображения атрибутов']],

        'accounting.attribute-groups.index' => ['title' => ['en' => 'Attribute groups', 'lt' => 'Atributų grupės', 'ru' => 'Группы атрибутов']],
        'accounting.attribute-groups.create' => ['title' => ['en' => 'Create attribute group', 'lt' => 'Sukurti atributų grupę', 'ru' => 'Создать группу атрибутов']],
        'accounting.attribute-groups.edit' => ['title' => ['en' => 'Edit attribute group', 'lt' => 'Redaguoti atributų grupę', 'ru' => 'Редактировать группу атрибутов']],
    ];

    /**
     * @return void
     */
    public function handle(): void
    {
        $this->emptyData();
        $this->sameData();

        $this->scanModules();

        $this->generateRoles();
        $this->generateRolesPermissions();
        $this->assignGuestPermissions();
        $this->assignAdminRoleToUser();

        $this->generatePages();
        $this->generateAttributes();
        $this->generateCategories();
        $this->generateBrands();

        $this->generateFromMenu();

        $this->generateSectionsAndBackMenu();

        $this->generateModulesData();
    }

    /**
     * @return void
     */
    private function sameData(): void
    {
        $this->sameData = [
            'content' => [
                'en' => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.",
                'lt' => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.",
                'ru' => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.",
            ],
            'is_visible' => true,
            'user_id' => 1,
        ];
    }

    /**
     * @return void
     */
    private function emptyData(): void
    {
        Page::query()->delete();
        PostCategory::query()->delete();
        Post::query()->delete();
        CustomLink::query()->delete();
        Menu::query()->delete();
        Item::query()->delete();
        Role::query()->delete();
        Permission::query()->delete();

        Attribute::query()->delete();
        AttributeGroup::query()->delete();
        ProductCategory::query()->delete();
        Brand::query()->delete();
        Model::query()->delete();
    }

    /**
     * @return void
     */
    private function generateModulesData(): void
    {
        foreach ($this->modules as $route => $title) {
            $module = ModuleAction::where('route_name', $route);
            $module->update($title);
        }
    }

    /**
     * @return void
     */
    private function generateRoles(): void
    {
        $roles = [
            [
                'name' => 'admin',
                'guard_name' => 'accounting',
            ],
            [
                'name' => 'administrator',
                'guard_name' => 'accounting',
            ],
            [
                'name' => 'copywriter',
                'guard_name' => 'accounting',
            ],
            [
                'name' => 'editor',
                'guard_name' => 'accounting',
            ],
            [
                'name' => 'seller',
                'guard_name' => 'accounting',
            ],
            [
                'name' => 'guest',
                'guard_name' => 'web',
            ],
        ];

        foreach ($roles as $role) {
            Role::query()->create($role);
        }
    }

    /**
     * @return void
     */
    private function generateRolesPermissions(): void
    {
        //Artisan::call('cache:clear');
        //app()->make(\Spatie\Permission\PermissionRegistrar::class)->forgetCachedPermissions();

        foreach (Viartas::driver()->app()->all() as $app) {
            (new RolesPermissionsForm())->appRoutes($app->tag);
        }
    }

    /**
     * @return void
     */
    private function assignGuestPermissions(): void
    {
        $permissions = Permission::query()
            ->where('guard_name', 'web')
            ->where('name', 'like', '%.index')
            ->get()->pluck('name');

        \Spatie\Permission\Models\Role::query()
            ->where('name', 'guest')
            ->where('guard_name', 'web')
            ->first()->syncPermissions($permissions);
    }

    /**
     * @return void
     */
    private function assignAdminRoleToUser(): void
    {
        $user = User::findOrFail(1);
        $role = \Spatie\Permission\Models\Role::query()
            ->where('name', 'admin')
            ->where('guard_name', 'accounting')
            ->first();

        $user->assignRole($role);
    }

    /**
     * @return void
     */
    private function scanModules(): void
    {
        (new ModulesTable(request()))->appRoutes();
    }

    /**
     * @return void
     */
    private function generateSectionsAndBackMenu(): void
    {
        $menu = Menu::create(array_merge($this->sameData, [
            'title' => ['en' => 'Sidebar', 'lt' => 'Šoninė juosta', 'ru' => 'Боковая панель'],
            'tag' => 'sidebar',
            'layout' => 'sidebar',
            'guard' => 'accounting',
            'depth' => 4,
        ]));

        $sameData = [
            'url' => ['en' => '#', 'lt' => '#', 'ru' => '#'],
            'is_visible' => true,
            'type' => 'section',
        ];

        $sections = [
            'Dashboard' => [
                'title' => ['en' => 'Dashboard', 'lt' => 'Darbalaukis', 'ru' => 'Рабочий стол'],
                'modules' => ['accounting.dashboard.index'],
            ],
            'Content' => [
                'title' => ['en' => 'Content', 'lt' => 'Turinys', 'ru' => 'Контент'],
                'modules' => [
                    'accounting.menus.index',
                    'accounting.pages.index',
                    'accounting.post-categories.index',
                    'accounting.posts.index',
                    'accounting.custom-links.index',
                ],
            ],
            'Ecommerce' => [
                'title' => ['en' => 'Shop', 'lt' => 'Parduotuvė', 'ru' => 'Магазин'],
                'modules' => [
                    'accounting.attribute-groups.index',
                    'accounting.attributes.index',
                    'accounting.product-categories.index',
                    'accounting.products.index',
                ],
            ],
            'Brands' => [
                'title' => ['en' => 'Brands', 'lt' => 'Gamintojai', 'ru' => 'Производители'],
                'modules' => [
                    'accounting.brands.index',
                    'accounting.models.index',
                ],
            ],
            'Users' => [
                'title' => ['en' => 'Users', 'lt' => 'Vartotojai', 'ru' => 'Пользователи'],
                'modules' => [
                    'accounting.users.index',
                    'accounting.roles.index',
                ],
            ],
            'Settings' => [
                'title' => ['en' => 'Settings', 'lt' => 'Nustatymai', 'ru' => 'Настройки'],
                'modules' => [
                    'accounting.modules.index',
                ],
            ],
        ];

        foreach ($sections as $key => $section) {
            // Create custom link
            $custom_link = CustomLink::query()->create(array_merge($sameData, [
                'title' => $section['title'],
            ]));

            // Create main section item in menu
            $menu_section = $menu->items()->create(array_merge($this->sameData, [
                'element' => $custom_link->id,
                'class' => 'ViartasModules\CustomLinks\Models\Accounting\CustomLink',
                'sort' => 1,
                'has_children' => 0,
            ]));

            // Create sub-menu items from module routes
            foreach ($section['modules'] as $routeName) {
                $module = ModuleAction::query()->where('route_name', $routeName)->first();

                if ($module) {
                    $menu->items()->create(array_merge($this->sameData, [
                        'element' => $module->id,
                        'class' => 'ViartasCore\Core\Models\ModuleAction',
                        'sort' => 1,
                        'menu_item_id' => $menu_section->id,
                        'has_children' => 0,
                    ]));
                }
            }
        }
    }

    /**
     * @return void
     */
    private function generateFromMenu(): void
    {
        $menu = Menu::create(array_merge($this->sameData, [
            'title' => ['en' => 'Top menu', 'lt' => 'Viršutinis meniu', 'Верхнее меню',],
            'tag' => 'top_menu',
            'guard' => 'web',
            'layout' => 'top',
            'depth' => 3,
        ]));

        $menu->items()->create(array_merge($this->sameData, [
            'element' => 0,
            'class' => 'ViartasModules\Pages\Models\Accounting\Page',
            'sort' => 1,
            'layout' => 'sidebar',
            'has_children' => 1,
        ]));

        $menu->items()->create(array_merge($this->sameData, [
            'element' => ProductCategory::query()->where('title->en', "Women's clothes")->first()->id,
            'class' => 'ViartasShop\ProductCategories\Models\Accounting\ProductCategory',
            'sort' => 2,
            'layout' => 'sidebar',
            'has_children' => 0,
        ]));
    }

    /**
     * @return void
     */
    private function generatePages(): void
    {
        $pages = [
            [
                'title' => ['en' => 'About us', 'lt' => 'Apie mus', 'ru' => 'О нас'],
            ],
            [
                'title' => ['en' => 'Contact us', 'lt' => 'Kontaktai', 'ru' => 'Контакты'],
            ],
            [
                'title' => ['en' => 'Terms and Conditions', 'lt' => 'Taisyklės ir sąlygos', 'ru' => 'Правила и условия'],
            ],
            [
                'title' => ['en' => 'Cookie Policy', 'lt' => 'Slapukų politika', 'ru' => 'Политика использования файлов cookie'],
                'children' => [
                    [
                        'title' => ['en' => 'Cookie Usage Rules', 'lt' => 'Slapukų naudojimo taisyklės', 'ru' => 'Правила использования файлов cookie'],
                    ],
                    [
                        'title' => ['en' => 'Personal Data Protection', 'lt' => 'Asmens duomenų apsauga', 'ru' => 'Защита персональных данных'],
                    ],
                ],
            ],
            [
                'title' => ['en' => 'For customers', 'lt' => 'Pirkėjams', 'ru' => 'Для покупателей'],
                'children' => [
                    [
                        'title' => ['en' => 'Payment Methods', 'lt' => 'Mokėjimo būdai', 'ru' => 'Способы оплаты'],
                    ],
                    [
                        'title' => ['en' => 'Delivery Terms', 'lt' => 'Pristatymo sąlygos', 'ru' => 'Условия доставки'],
                    ],
                    [
                        'title' => ['en' => 'Return Policy', 'lt' => 'Grąžinimo garantijos', 'ru' => 'Гарантия возврата'],
                    ],
                    [
                        'title' => ['en' => 'Warranty', 'lt' => 'Garantijos', 'ru' => 'Гарантия'],
                    ],
                ]
            ],

        ];

        foreach ($pages as $page) {
            $created = Page::query()->create(
                array_merge($page, $this->sameData)
            );

            if (isset($page['children'])) {
                foreach ($page['children'] as $child) {
                    $child['page_id'] = $created->id;
                    Page::query()->create(
                        array_merge($child, $this->sameData)
                    );
                }
            }
        }
    }

    /**
     * @return void
     */
    private function generateAttributes(): void
    {
        $attributes = [
            [
                'title' => ['en' => 'Electronics', 'lt' => 'Elektronika', 'ru' => 'Электроника'],
                'tag' => 'electronics',
                'children' => [
                    [
                        'title' => ['en' => 'Type', 'lt' => 'Tipas', 'ru' => 'Тип'],
                        'tag' => 'type',
                        'is_visible' => true,
                    ],
                ],
            ],

            [
                'title' => ['en' => 'Phones', 'lt' => 'Telefonai', 'ru' => 'Телефоны'],
                'tag' => 'phones',
                'children' => [
                    [
                        'title' => ['en' => 'Screen size', 'lt' => 'Ekrano dydis', 'ru' => 'Размер экрана'],
                        'tag' => 'screen_size',
                        'is_visible' => true,
                    ],
                ],
            ],

            [
                'title' => ['en' => 'Clothes', 'lt' => 'Drabužiai', 'ru' => 'Одежда'],
                'tag' => 'clothes',
                'children' => [
                    [
                        'title' => ['en' => 'Size', 'lt' => 'Dydis', 'ru' => 'Размер'],
                        'tag' => 'size',
                        'is_visible' => true,
                    ],
                    [
                        'title' => ['en' => 'Color', 'lt' => 'Spalva', 'ru' => 'Цвет'],
                        'tag' => 'color',
                        'is_visible' => true,
                    ],
                ],
            ],
        ];

        foreach ($attributes as $attribute) {
            $created = AttributeGroup::query()->create(
                array_merge($attribute, $this->sameData)
            );

            if (isset($attribute['children'])) {
                foreach ($attribute['children'] as $child) {
                    $child['attribute_group_id'] = $created->id;
                    Attribute::query()->create(
                        array_merge($child, $this->sameData)
                    );
                }
            }
        }
    }

    /**
     * @return void
     */
    private function generateCategories(): void
    {
        $categories = [
            [
                'title' => [
                    'en' => "Women's clothes",
                    'lt' => 'Moteriški drabužiai',
                    'ru' => 'Женская одежда',
                ],
                'children' => [
                    ['title' => ['en' => 'Dresses',           'lt' => 'Suknelės',                  'ru' => 'Платья']],
                    ['title' => ['en' => 'Tops & T-shirts',   'lt' => 'Topai ir marškinėliai',     'ru' => 'Топы и футболки']],
                    ['title' => ['en' => 'Skirts',            'lt' => 'Sijonai',                    'ru' => 'Юбки']],
                    ['title' => ['en' => 'Pants',             'lt' => 'Kelnės',                     'ru' => 'Брюки']],
                ],
                'attributes' => [
                    'size', 'color',
                ],
            ],
            [
                'title' => [
                    'en' => 'Electronics',
                    'lt' => 'Elektronika',
                    'ru' => 'Электроника',
                ],
                'children' => [
                    [
                        'title' => ['en' => 'Phones', 'lt' => 'Telefonai',    'ru' => 'Телефоны'],
                        'attributes' => [
                            'screen_size',
                        ],
                    ],
                    ['title' => ['en' => 'PC',     'lt' => 'Kompiuteriai', 'ru' => 'ПК']],
                ],
                'attributes' => [
                    'type',
                ],
            ],
        ];

        foreach ($categories as $category) {
            $created = ProductCategory::query()->create(
                array_merge($category, $this->sameData)
            );

            if (isset($category['attributes'])) {
                $attributes = Attribute::query()->whereIn('tag', $category['attributes'])->get();
                $created->attrs()->sync($attributes);
            }

            if (isset($category['children'])) {
                foreach ($category['children'] as $child) {
                    $child['product_category_id'] = $created->id;
                    $child_created = ProductCategory::query()->create(
                        array_merge($child, $this->sameData)
                    );

                    if (isset($child['attributes'])) {
                        $attributes = Attribute::query()->whereIn('tag', $child['attributes'])->get();
                        $child_created->attrs()->sync($attributes);
                    }
                }
            }
        }
    }

    /**
     * @return void
     */
    private function generateBrands(): void
    {
        $brands = [
            [
                'title' => ['en' => 'Samsung', 'lt' => 'Samsung', 'ru' => 'Samsung'],
                'tag'   => 'samsung',
                'children' => [
                    [
                        'title'  => ['en' => 'Galaxy S20', 'lt' => 'Galaxy S20', 'ru' => 'Galaxy S20'],
                        'tag'    => 'galaxy_s20',
                        'series' => 'Galaxy', // added
                    ],
                    [
                        'title'  => ['en' => 'Galaxy S21', 'lt' => 'Galaxy S21', 'ru' => 'Galaxy S21'],
                        'tag'    => 'galaxy_s21',
                        'series' => 'Galaxy', // added
                    ],
                    [
                        'title'  => ['en' => 'Galaxy S22', 'lt' => 'Galaxy S22', 'ru' => 'Galaxy S22'],
                        'tag'    => 'galaxy_s22',
                        'series' => 'Galaxy', // added
                    ],
                ],
            ],
            [
                'title' => ['en' => 'Apple', 'lt' => 'Apple', 'ru' => 'Apple'],
                'tag'   => 'apple',
                'children' => [
                    ['title' => ['en' => 'iPhone 12', 'lt' => 'iPhone 12', 'ru' => 'iPhone 12'], 'tag' => 'iphone_12'],
                    ['title' => ['en' => 'iPhone 13', 'lt' => 'iPhone 13', 'ru' => 'iPhone 13'], 'tag' => 'iphone_13'],
                    ['title' => ['en' => 'iPhone 14', 'lt' => 'iPhone 14', 'ru' => 'iPhone 14'], 'tag' => 'iphone_14'],
                    ['title' => ['en' => 'iPhone 15', 'lt' => 'iPhone 15', 'ru' => 'iPhone 15'], 'tag' => 'iphone_15'],
                    ['title' => ['en' => 'iPhone 16', 'lt' => 'iPhone 16', 'ru' => 'iPhone 16'], 'tag' => 'iphone_16'],
                ],
            ],

            // Clothes brands
            [
                'title' => ['en' => 'Nike', 'lt' => 'Nike', 'ru' => 'Nike'],
                'tag'   => 'nike',
                'children' => [
                    ['title' => ['en' => 'Air Max',     'lt' => 'Air Max',     'ru' => 'Air Max'],     'tag' => 'air_max'],
                    ['title' => ['en' => 'Air Force 1', 'lt' => 'Air Force 1', 'ru' => 'Air Force 1'], 'tag' => 'air_force_1'],
                    ['title' => ['en' => 'Dri-FIT',     'lt' => 'Dri-FIT',     'ru' => 'Dri-FIT'],     'tag' => 'dri_fit'],
                ],
            ],
            [
                'title' => ['en' => 'Adidas', 'lt' => 'Adidas', 'ru' => 'Adidas'],
                'tag'   => 'adidas',
                'children' => [
                    ['title' => ['en' => 'Ultraboost', 'lt' => 'Ultraboost', 'ru' => 'Ultraboost'], 'tag' => 'ultraboost'],
                    ['title' => ['en' => 'Superstar',  'lt' => 'Superstar',  'ru' => 'Superstar'],  'tag' => 'superstar'],
                    ['title' => ['en' => 'Terrex',     'lt' => 'Terrex',     'ru' => 'Terrex'],     'tag' => 'terrex'],
                ],
            ],
            [
                'title' => ['en' => 'Zara', 'lt' => 'Zara', 'ru' => 'Zara'],
                'tag'   => 'zara',
                'children' => [
                    ['title' => ['en' => 'Basic',     'lt' => 'Basic',     'ru' => 'Basic'],     'tag' => 'basic'],
                    ['title' => ['en' => 'Join Life', 'lt' => 'Join Life', 'ru' => 'Join Life'], 'tag' => 'join_life'],
                    ['title' => ['en' => 'TRF',       'lt' => 'TRF',       'ru' => 'TRF'],       'tag' => 'trf'],
                ],
            ],
            [
                'title' => ['en' => 'H&M', 'lt' => 'H&M', 'ru' => 'H&M'],
                'tag'   => 'h_m',
                'children' => [
                    ['title' => ['en' => 'Conscious', 'lt' => 'Conscious', 'ru' => 'Conscious'], 'tag' => 'conscious'],
                    ['title' => ['en' => 'Divided',   'lt' => 'Divided',   'ru' => 'Divided'],   'tag' => 'divided'],
                ],
            ],
            [
                'title' => ['en' => "Levi's", 'lt' => "Levi's", 'ru' => "Levi's"],
                'tag'   => 'levis',
                'children' => [
                    ['title' => ['en' => '501', 'lt' => '501', 'ru' => '501'], 'tag' => '501'],
                    ['title' => ['en' => '511', 'lt' => '511', 'ru' => '511'], 'tag' => '511'],
                    ['title' => ['en' => 'Wedgie', 'lt' => 'Wedgie', 'ru' => 'Wedgie'], 'tag' => 'wedgie'],
                ],
            ],
        ];

        foreach ($brands as $brand) {
            $created = Brand::query()->create(
                array_merge($brand, $this->sameData)
            );

            if (isset($brand['children'])) {
                foreach ($brand['children'] as $child) {
                    $child['brand_id'] = $created->id;

                    if ($brand['tag'] == 'apple' || $brand['tag'] == 'samsung') {
                        $category = ProductCategory::query()->where('title->en', 'Phones')->first();
                    } else {
                        $category = ProductCategory::query()->where('title->en', "Women's clothes")->first();
                    }

                    $child['product_category_id'] = $category->id;

                    Model::query()->create(
                        array_merge($child, $this->sameData)
                    );
                }
            }
        }
    }
}
