<?php

use ViartasCore\Core\Facades\Route;
use ViartasCore\Auth\Facades\AuthUi;
use ViartasCore\Core\Controllers\MediaController;
use ViartasCore\Core\Controllers\MenusController;
use ViartasCore\Core\Controllers\MetaController;
use ViartasCore\Core\Controllers\ModulesActionsController;
use ViartasCore\Core\Controllers\ModulesController;
use ViartasCore\Core\Controllers\RolesController;
use ViartasCore\Core\Controllers\UsersController;

AuthUi::routes([
    'register' => false, // Register Routes...
]);

Route::middleware('auth')->group(function () {

    Route::get('/#')->name('empty.route');

    Route::prefix('meta')->group(function () {
        Route::get('/{id}/{class}/edit', [MetaController::class, 'edit'])->name('meta.edit');
        Route::post('/{id}/{class}/edit', [MetaController::class, 'update'])->name('meta.edit');
        Route::patch('/{id}/{class}/edit', [MetaController::class, 'updateOneField'])->name('meta.edit');
    });

    Route::prefix('media')->group(function () {
        Route::post('/{id}/upload', [MediaController::class, 'upload'])->name('media.upload');
    });

    Route::prefix('users')->group(function () {
        Route::get('/', [UsersController::class, 'index'])->name('users.index');
        Route::get('/create', [UsersController::class, 'create'])->name('users.create');
        Route::post('/create', [UsersController::class, 'store'])->name('users.create');
        Route::get('/{id}/edit', [UsersController::class, 'edit'])->name('users.edit');
        Route::post('/{id}/edit', [UsersController::class, 'update'])->name('users.edit');
        Route::patch('/{id}/edit', [UsersController::class, 'updateOneField'])->name('users.edit');
        Route::post('/{id}/destroy', [UsersController::class, 'destroy'])->name('users.destroy');
        Route::get('/{id}/roles', [UsersController::class, 'rolesEdit'])->name('users.roles.edit');
        Route::post('/{id}/roles', [UsersController::class, 'rolesUpdate'])->name('users.roles.edit');
    });

    Route::prefix('roles')->group(function () {
        Route::get('/', [RolesController::class, 'index'])->name('roles.index');
        Route::get('/create', [RolesController::class, 'create'])->name('roles.create');
        Route::post('/create', [RolesController::class, 'store'])->name('roles.create');
        Route::get('/{id}/edit', [RolesController::class, 'edit'])->name('roles.edit');
        Route::post('/{id}/edit', [RolesController::class, 'update'])->name('roles.edit');
        Route::patch('/{id}/edit', [RolesController::class, 'updateOneField'])->name('roles.edit');
        Route::get('/{id}/permissions', [RolesController::class, 'permissionsEdit'])->name('roles.permissions.edit');
        Route::post('/{id}/permissions', [RolesController::class, 'permissionsUpdate'])->name('roles.permissions.edit');
        Route::post('/{id}/destroy', [RolesController::class, 'destroy'])->name('roles.destroy');
    });

    Route::prefix('modules')->group(function () {
        Route::get('/', [ModulesController::class, 'index'])->name('modules.index');
        Route::get('/{id}/list', [ModulesController::class, 'list'])->name('modules.list');
        Route::get('/{id}/edit', [ModulesController::class, 'edit'])->name('modules.edit');
        Route::post('/{id}/edit', [ModulesController::class, 'update'])->name('modules.edit');
        Route::patch('/{id}/edit', [ModulesController::class, 'updateOneField'])->name('modules.edit');
        Route::post('/{id}/destroy', [ModulesController::class, 'destroy'])->name('modules.destroy');
        Route::get('/{id}/actions', [ModulesController::class, 'actions'])->name('modules.actions');
        Route::get('/{id}/actions/{action}/edit', [ModulesActionsController::class, 'edit'])->name('modules.actions.edit');
        Route::post('/{id}/actions/{action}/edit', [ModulesActionsController::class, 'update'])->name('modules.actions.edit');
        Route::patch('/{id}/actions/{action}/edit', [ModulesActionsController::class, 'updateOneField'])->name('modules.actions.edit');
        Route::get('/{id}/upload/images', [ModulesActionsController::class, 'uploadImages'])->name('modules.upload.images');

        Route::get('/{id}/{class}/edit', [ModulesActionsController::class, 'editMeta'])->name('modules.meta.edit');
        Route::post('/{id}/{class}/edit', [ModulesActionsController::class, 'updateMeta'])->name('modules.meta.edit');
    });

    Route::prefix('menus')->group(function () {
        Route::get('/', [MenusController::class, 'index'])->name('menus.index');
        Route::get('/create', [MenusController::class, 'create'])->name('menus.create');
        Route::post('/create', [MenusController::class, 'store'])->name('menus.create');
        Route::get('/{id}/edit', [MenusController::class, 'edit'])->name('menus.edit');
        Route::post('/{id}/edit', [MenusController::class, 'update'])->name('menus.edit');
        Route::patch('/{id}/edit', [MenusController::class, 'updateOneField'])->name('menus.edit');
        Route::get('/{id}/list', [MenusController::class, 'list'])->name('menus.list');
        Route::post('/{id}/list', [MenusController::class, 'save'])->name('menus.list');
        Route::get('/{id}/history', [MenusController::class, 'history'])->name('menus.history');
        Route::post('/{id}/destroy', [MenusController::class, 'destroy'])->name('menus.destroy');

        Route::get('/items/modules', [MenusController::class, 'modules'])->name('menus.items.modules');
        Route::get('/items/pages', [MenusController::class, 'pages'])->name('menus.items.pages');
        Route::get('/items/post_categories', [MenusController::class, 'post_categories'])->name('menus.items.post-categories');
        Route::get('/items/custom_links', [MenusController::class, 'custom_links'])->name('menus.items.custom-links');
        Route::get('/items/product_categories', [MenusController::class, 'product_categories'])->name('menus.items.product-categories');
        Route::get('/items/brands', [MenusController::class, 'brands'])->name('menus.items.brands');
    });
});
