const config = {
    title: "Are you sure?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Yes, delete it!",
    cancelButtonText: "No, cancel!",
    reverseButtons: true
};

function getFields () {

    var form = $(document).find(".card-body form");
    var resp;

    if ($('.get-fields').length) {
        $(".get-fields").each(function () {
            $.ajax({
                async: false, type: "POST", cache: false, url: $(this).attr("data-url"),
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {"form": form.serialize(), "selected": $(this).attr("data-selected"), "where": $(this).attr("data-where"), "name": $(this).attr("data-name")},
                success: function (response) {
                    resp = response;
                },
                error: function (response) {


                }
            });

            $(this).find("option").each(function () {
                $(this).remove();
            });

            $(this).append(resp);
        });
    }
}

function toggleHidden () {
    if ($(".toggle-field").length) {
        $(".toggle-field").each(function () {

            var values = $(this).attr("data-value").split(',');

            //if ($(this).val() == $(this).attr("data-value")) {
            if ($.inArray($(this).val(), values) != -1) {
                $("." + $(this).attr("data-toggle")).show();
            } else {
                $("." + $(this).attr("data-toggle")).find('select').val("");
                $("." + $(this).attr("data-toggle")).hide();
            }
        });
    }

    if ($(".toggle-field-second").length) {
        $(".toggle-field-second").each(function () {

            var values = $(this).attr("data-value-second").split(',');

            if ($.inArray($(this).val(), values) != -1) {
                $("." + $(this).attr("data-toggle-second")).show();
            } else {
                $("." + $(this).attr("data-toggle-second")).find('select').val("");
                $("." + $(this).attr("data-toggle-second")).hide();
            }
        });
    }

    if ($(".toggle-field-third").length) {
        $(".toggle-field-third").each(function () {

            var values = $(this).attr("data-value-third").split(',');

            if ($.inArray($(this).val(), values) != -1) {
                $("." + $(this).attr("data-toggle-third")).show();
            } else {
                $("." + $(this).attr("data-toggle-third")).find('select').val("");
                $("." + $(this).attr("data-toggle-third")).hide();
            }
        });
    }

    if ($(".toggle-field-fourth").length) {
        $(".toggle-field-fourth").each(function () {

            var values = $(this).attr("data-value-fourth").split(',');

            if ($.inArray($(this).val(), values) != -1) {
                $("." + $(this).attr("data-toggle-fourth")).show();
            } else {
                $("." + $(this).attr("data-toggle-fourth")).find('select').val("");
                $("." + $(this).attr("data-toggle-fourth")).hide();
            }
        });
    }
}

function dynamicSections() {
    $('.dynamic-section').each(function() {

        var section = $(this);

        $.ajax({
            async: false, type: "POST", cache: false, url: $(this).attr("data-url"),
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function (response) {
                section.html(response);
            }
        });
    });

    setTimeout(dynamicSections, 10000);
}

$("document").ready(function() {

    $(document).on("click", ".destroy-selected-button", function(e) {
        e.preventDefault();
        const route = $(this).parent().attr('action');

        Swal.fire(config).then(function(result) {
            if (result.value) {

                let elements = [];

                $("table.dataTable input.table-checkbox").each(function () {
                    if ($(this).is(":checked")) {
                        elements.push($(this).attr('rel'));
                    }
                });

                $.ajax({
                    async:false, type: "POST", cache: false, url: route,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {"elements": elements},
                });

                location.reload();

                return false;
            }
        });

        return false;
    });

    $(document).on("click", ".confirm-button", function(e) {
        e.preventDefault();
        const href = $(this).attr('href');
        Swal.fire(config).then(function(result) {
            if (result.value) {
                location.href = href;
            }
        });
    });

    $(document).on("click", ".confirm-form", function(e) {
        e.preventDefault();
        const button = $(this);
        Swal.fire(config).then(function(result) {
            if (result.value) {
                button.parent().submit();
            }
        });
    });

    if ($('.dynamic-section').length) {
        setTimeout(dynamicSections, 10000);
    }
});

$("document").ready(function() {
    toggleHidden();
    getFields();

    $(".toggle-get").on("change", function () {
        getFields();
    });

    $(".toggle-field").on("change", function () {
        toggleHidden();
    });
});

$("document").ready(function() {

    $(".start-ajax-edit").on("click", function (e) {
        e.preventDefault();
        $(".inline-ajax-edit[data-id="+$(this).attr("data-id")+"] .value-name").hide();
        $(".inline-ajax-edit[data-id="+$(this).attr("data-id")+"] .value-edit").show();
    });

    $(".inline-ajax-edit form").on("submit", function (e) {
        e.preventDefault();
        var form = $(this);

        $(".inline-ajax-edit[data-id="+$(this).attr("data-id")+"] .ajax-btn").attr("data-kt-indicator", "on");
        $(".inline-ajax-edit[data-id="+$(this).attr("data-id")+"] .ajax-btn").attr("disabled", "true");

        $.ajax({
            async:true, type: "POST", cache: false, url: form.attr("action"),
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: form.serialize(),
            success: function(response){
                $(".inline-ajax-edit[data-id=" + form.attr("data-id") + "] .ajax-btn").removeAttr("data-kt-indicator");
                $(".inline-ajax-edit[data-id=" + form.attr("data-id") + "] .ajax-btn").removeAttr("disabled");

                $(".inline-ajax-edit[data-id=" + form.attr("data-id") + "] .value-name").html(response.name).show();
                $(".inline-ajax-edit[data-id=" + form.attr("data-id") + "] .value-edit").hide();
                if ($(".inline-ajax-edit[data-id=" + form.attr("data-id") + "] .value-edit .ajax-input").hasClass("input-error"))
                    $(".inline-ajax-edit[data-id=" + form.attr("data-id") + "] .value-edit .ajax-input").removeClass("input-error");
            },
            error: function (response) {
                $(".inline-ajax-edit[data-id=" + form.attr("data-id") + "] .ajax-btn").removeAttr("data-kt-indicator");
                $(".inline-ajax-edit[data-id=" + form.attr("data-id") + "] .ajax-btn").removeAttr("disabled");

                $(".inline-ajax-edit[data-id=" + form.attr("data-id") + "] .value-edit .ajax-input").addClass("input-error");

            }
        });
    });

    $(".delete-selected").on("click", function (e) {
        e.preventDefault();

        var resp = '';
        var elements = [];
        var obj = $(this);

        $("table.table").find("input:checkbox").each(function () {
            if ($(this).is(":checked")) elements.push($(this).attr('data-id'));
        });

        Swal.fire(config).then(function(result) {
            if (result.value) {
                $.ajax({
                    async:false, type: "POST", cache: false, url: obj.attr('data-url'),
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {"elements": JSON.stringify(elements)},
                    success: function(response){
                        resp = response;
                    }
                });

                location.href = resp;
            }
        });

    });

    $(".th-icon").on("click", function (e) {
        e.preventDefault();
        var obj = this;

        $(this).parent().parent().parent().parent().parent().find('input:checkbox').each(function () {
            if ($(obj).hasClass('table-plus'))
                $(this).prop( "checked", true );
            else
                $(this).prop( "checked", false );
        });
    });

    $(document).on("click", ".delete-button", function(e) {
        e.preventDefault();
        var form = $(this).parent();
        Swal.fire(config).then(function(result) {
            if (result.value) {
                form.submit();
            }
        });
    });

    $(document).on("click", ".table-check-all", function(e) {
        $(this).parent().parent().parent().parent().find('.table-checkbox').each(function () {
            $(this).prop('checked', true);
        });
        return false;
    });

    $(document).on("click", ".table-uncheck-all", function(e) {
        $(this).parent().parent().parent().parent().find('.table-checkbox').each(function () {
            $(this).prop('checked', false);
        });
        return false;
    });
});
