<?php

namespace App\Providers;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use ViartasCore\Core\Controllers\RouteGuessers\AccountingRouteGuesserController;
use ViartasCore\Core\Controllers\RouteGuessers\WebRouteGuesserController;
use ViartasCore\Core\Facades\Viartas;

class AppServiceProvider extends ServiceProvider
{
    /**
     * @var array|string[]
     */
    protected array $guards = [
        'api' => 'api',
        'default' => 'web',
    ];

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register(): void
    {

    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot(): void
    {
        $this->addRoutes();
    }

    private function addRoutes(): void
    {
        $locales = Viartas::driver()->locale()->all();

        Route::middleware('web')
            ->prefix('accounting')
            ->as('accounting.')
            ->group(function () {
                Route::prefix('')->group(function () {
                    Route::get('{any}', [AccountingRouteGuesserController::class, 'guessRoute'])
                        ->where('any', '^.*$')->name('any.index');
                });
            });

        Route::middleware('web')
            ->prefix('')
            ->as('web.')
            ->group(function () use ($locales) {

                Route::prefix('')->group(function () {
                    Route::get('{any}', [WebRouteGuesserController::class, 'guessRoute'])
                        ->where('any', '^.*$')->name('any.index');
                });

                /*foreach ($locales as $language) {
                    $prefix = '';
                    $as = '';
                    if (!$language->is_default) {
                        $prefix = $language->tag;
                        $as = $language->tag.'.';
                    }

                    Route::prefix($prefix)->as($as)->group(function () {
                        Route::get('{any}', [WebRouteGuesserController::class, 'guessRoute'])
                            ->where('any', '^.*$')->name('any.index');
                    });
                }*/
            });
    }
}
