<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use ViartasCore\Core\Models\Application;
use ViartasCore\Core\Models\Segment;
use ViartasCore\Core\Models\Locale;

class createApplicationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('applications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('segment_id')->constrained()->cascadeOnDelete();
            $table->jsonb('title');
            $table->string('tag')->index();
            $table->boolean('is_default')->default(0)->index();
            $table->boolean('is_active')->default(1)->index();
            $table->timestamps();
        });

        Segment::query()->create([
            'title' => 'Application',
            'tag' => 'application',
            'priority' => '0',
            'is_active' => '1',
        ]);

        Segment::query()->create([
            'title' => 'Locale',
            'tag' => 'locale',
            'priority' => '1',
            'is_active' => '1',
        ]);

        Application::query()->create([
            'segment_id' => 1,
            'title' => 'WEB',
            'tag' => 'web',
            'is_default' => 1
        ]);

        Application::query()->create([
            'segment_id' => 1,
            'title' => 'Accounting',
            'tag' => 'accounting',
        ]);

        Application::query()->create([
            'segment_id' => 1,
            'title' => 'B2B',
            'tag' => 'b2b',
        ]);

        Application::query()->create([
            'segment_id' => 1,
            'title' => 'API',
            'tag' => 'api',
        ]);


        $locales = [
            [
                'tag' => 'en',
                'is_default' => 1,
            ],
            [
                'tag' => 'lt',
            ],
            [
                'tag' => 'ru',
            ],
        ];

        foreach ($locales as $locale) {
            Locale::query()->create(array_merge($locale, ['segment_id' => 2]));
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {

    }
};
