<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('metas', function (Blueprint $table) {
            $table->id();
            $table->integer('element')->index();
            $table->string('class')->index();
            $table->jsonb('title')->nullable();
            $table->jsonb('keywords')->nullable();
            $table->jsonb('description')->nullable();

            $table->jsonb('menu_title')->nullable();
            $table->string('menu_icon')->nullable()->index();
            $table->string('menu_class')->nullable()->index();
            $table->string('menu_styles')->nullable()->index();
            $table->string('menu_attributes')->nullable()->index();
            $table->string('menu_target')->nullable()->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {

    }
};
