<?php

namespace ViartasCore\Core\Traits;

use ViartasCore\Core\Contracts\RouteGuesserContract;
use ViartasCore\Core\Facades\Viartas;

Trait HasRoutes {

    public function boot(): void
    {
        parent::boot();

        $this->routeGuesser(
            $this->routeGuesserClass()
        );
    }

    /**
     * @param RouteGuesserContract $routeGuesser
     * @return void
     */
    public function routeGuesser(RouteGuesserContract $routeGuesser): void
    {
        Viartas::driver()->app()->addPackageRouteGuesser($routeGuesser);
    }
}
