<?php

namespace ViartasCore\Core\Traits;

use Illuminate\Database\Eloquent\Relations\HasOne;
use ViartasCore\Core\Drivers\RouteDriver;
use ViartasCore\Core\Models\Meta;

Trait HasMetaTags
{
    /**
     * @var bool
     */
    protected bool $hasMetaTags = true;

    /**
     * @return HasOne
     */
    public function meta(): HasOne
    {
        return $this->hasOne(Meta::class, 'element', 'id')->where('class', get_class($this));
    }

    /**
     * @return RouteDriver
     */
    public function routeMeta(): RouteDriver
    {
        $route = 'accounting.meta.edit';

        return new RouteDriver($route, [
            'id' => $this->id,
            'class' => base64_encode(get_class($this)),
        ]);
    }

    /**
     * @return void
     */
    protected static function bootHasMetaTags(): void
    {
        self::addPackageMenuItem('meta', 'Meta data', 'routeMeta');
    }
}
